/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.RealmAuthenticator;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class CredentialsAuthenticator {
    private final DbClient dbClient;
    private final RealmAuthenticator externalAuthenticator;
    private final AuthenticationEvent authenticationEvent;

    public CredentialsAuthenticator(DbClient dbClient, RealmAuthenticator externalAuthenticator, AuthenticationEvent authenticationEvent) {
        this.dbClient = dbClient;
        this.externalAuthenticator = externalAuthenticator;
        this.authenticationEvent = authenticationEvent;
    }

    public UserDto authenticate(String userLogin, String userPassword, HttpServletRequest request, AuthenticationEvent.Method method) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.authenticate(dbSession, userLogin, userPassword, request, method);
            return userDto;
        }
    }

    private UserDto authenticate(DbSession dbSession, String userLogin, String userPassword, HttpServletRequest request, AuthenticationEvent.Method method) {
        UserDto localUser = this.dbClient.userDao().selectActiveUserByLogin(dbSession, userLogin);
        if (localUser != null && localUser.isLocal()) {
            UserDto userDto = CredentialsAuthenticator.authenticateFromDb(localUser, userPassword, method);
            this.authenticationEvent.loginSuccess(request, userLogin, AuthenticationEvent.Source.local(method));
            return userDto;
        }
        Optional<UserDto> externalUser = this.externalAuthenticator.authenticate(userLogin, userPassword, request, method);
        if (externalUser.isPresent()) {
            return externalUser.get();
        }
        throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(method)).setLogin(userLogin).setMessage(localUser != null && !localUser.isLocal() ? "User is not local" : "No active user for login").build();
    }

    private static UserDto authenticateFromDb(UserDto userDto, String userPassword, AuthenticationEvent.Method method) {
        String salt;
        String cryptedPassword = userDto.getCryptedPassword();
        String failureCause = CredentialsAuthenticator.checkPassword(cryptedPassword, salt = userDto.getSalt(), userPassword);
        if (failureCause == null) {
            return userDto;
        }
        throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(method)).setLogin(userDto.getLogin()).setMessage(failureCause).build();
    }

    @CheckForNull
    private static String checkPassword(@Nullable String cryptedPassword, @Nullable String salt, String userPassword) {
        if (cryptedPassword == null) {
            return "null password in DB";
        }
        if (salt == null) {
            return "null salt";
        }
        if (!cryptedPassword.equals(UserDto.encryptPassword((String)userPassword, (String)salt))) {
            return "wrong password";
        }
        return null;
    }
}

