/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.settings;

import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.api.config.internal.ConfigurationBridge;
import org.sonar.db.DbClient;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.settings.ChildSettings;

@ComputeEngineSide
public class ProjectConfigurationFactory {
    private final Settings globalSettings;
    private final DbClient dbClient;

    public ProjectConfigurationFactory(Settings globalSettings, DbClient dbClient) {
        this.globalSettings = globalSettings;
        this.dbClient = dbClient;
    }

    public Configuration newProjectConfiguration(String projectKey, Branch branch) {
        ChildSettings projectSettings = new ChildSettings(this.globalSettings);
        this.addSettings(projectSettings, projectKey);
        this.addSettings(projectSettings, ComponentDto.generateBranchKey((String)projectKey, (String)branch.getName()));
        return new ConfigurationBridge((Settings)projectSettings);
    }

    private void addSettings(Settings settings, String componentDbKey) {
        this.dbClient.propertiesDao().selectProjectProperties(componentDbKey).forEach(property -> settings.setProperty(property.getKey(), property.getValue()));
    }
}

