/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.ce.queue.CeQueue;
import org.sonar.ce.queue.CeTask;
import org.sonar.ce.queue.CeTaskSubmit;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.organization.DefaultOrganizationProvider;

@ComputeEngineSide
public class CeQueueImpl
implements CeQueue {
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private AtomicBoolean submitPaused = new AtomicBoolean(false);

    public CeQueueImpl(DbClient dbClient, UuidFactory uuidFactory, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    @Override
    public CeTaskSubmit.Builder prepareSubmit() {
        return new CeTaskSubmit.Builder(this.uuidFactory.create());
    }

    @Override
    public CeTask submit(CeTaskSubmit submission) {
        Preconditions.checkState((!this.submitPaused.get() ? 1 : 0) != 0, (Object)"Compute Engine does not currently accept new tasks");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            CeQueueDto dto = new CeTaskSubmitToInsertedCeQueueDto(dbSession, this.dbClient).apply(submission);
            CeTask task = this.loadTask(dbSession, dto);
            dbSession.commit();
            CeTask ceTask = task;
            return ceTask;
        }
    }

    @Override
    public List<CeTask> massSubmit(Collection<CeTaskSubmit> submissions) {
        Preconditions.checkState((!this.submitPaused.get() ? 1 : 0) != 0, (Object)"Compute Engine does not currently accept new tasks");
        if (submissions.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession dbSession = this.dbClient.openSession(true);){
            ImmutableList ceQueueDtos = FluentIterable.from(submissions).transform((Function)new CeTaskSubmitToInsertedCeQueueDto(dbSession, this.dbClient)).toList();
            List<CeTask> tasks = this.loadTasks(dbSession, (List<CeQueueDto>)ceQueueDtos);
            dbSession.commit();
            List<CeTask> list = tasks;
            return list;
        }
    }

    protected CeTask loadTask(DbSession dbSession, CeQueueDto dto) {
        if (dto.getComponentUuid() == null) {
            return new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid()).apply(dto);
        }
        Optional componentDto = this.dbClient.componentDao().selectByUuid(dbSession, dto.getComponentUuid());
        if (componentDto.isPresent()) {
            return new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid(), (Map<String, ComponentDto>)ImmutableMap.of((Object)dto.getComponentUuid(), (Object)componentDto.get())).apply(dto);
        }
        return new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid()).apply(dto);
    }

    private List<CeTask> loadTasks(DbSession dbSession, List<CeQueueDto> dtos) {
        ImmutableSet componentUuids = FluentIterable.from(dtos).transform((Function)CeQueueDtoToComponentUuid.INSTANCE).filter(Predicates.notNull()).toSet();
        ImmutableMap componentDtoByUuid = FluentIterable.from((Iterable)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids)).uniqueIndex(ComponentDto::uuid);
        return FluentIterable.from(dtos).transform((Function)new CeQueueDtoToCeTask(this.defaultOrganizationProvider.get().getUuid(), (Map<String, ComponentDto>)componentDtoByUuid)).toList();
    }

    @Override
    public void cancel(DbSession dbSession, CeQueueDto ceQueueDto) {
        Preconditions.checkState((boolean)CeQueueDto.Status.PENDING.equals((Object)ceQueueDto.getStatus()), (String)"Task is in progress and can't be canceled [uuid=%s]", (Object[])new Object[]{ceQueueDto.getUuid()});
        this.cancelImpl(dbSession, ceQueueDto);
    }

    private void cancelImpl(DbSession dbSession, CeQueueDto q) {
        CeActivityDto activityDto = new CeActivityDto(q);
        activityDto.setStatus(CeActivityDto.Status.CANCELED);
        this.remove(dbSession, q, activityDto);
    }

    @Override
    public int cancelAll() {
        return this.cancelAll(false);
    }

    protected int cancelAll(boolean includeInProgress) {
        int count = 0;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            for (CeQueueDto queueDto : this.dbClient.ceQueueDao().selectAllInAscOrder(dbSession)) {
                if (!includeInProgress && queueDto.getStatus().equals((Object)CeQueueDto.Status.IN_PROGRESS)) continue;
                this.cancelImpl(dbSession, queueDto);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    protected void remove(DbSession dbSession, CeQueueDto queueDto, CeActivityDto activityDto) {
        this.dbClient.ceActivityDao().insert(dbSession, activityDto);
        this.dbClient.ceQueueDao().deleteByUuid(dbSession, queueDto.getUuid());
        this.dbClient.ceTaskInputDao().deleteByUuids(dbSession, Collections.singleton(queueDto.getUuid()));
        dbSession.commit();
    }

    @Override
    public void pauseSubmit() {
        this.submitPaused.set(true);
    }

    @Override
    public void resumeSubmit() {
        this.submitPaused.set(false);
    }

    @Override
    public boolean isSubmitPaused() {
        return this.submitPaused.get();
    }

    private static enum CeQueueDtoToComponentUuid implements Function<CeQueueDto, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nonnull CeQueueDto input) {
            return input.getComponentUuid();
        }
    }

    private static class CeTaskSubmitToInsertedCeQueueDto
    implements Function<CeTaskSubmit, CeQueueDto> {
        private final DbSession dbSession;
        private final DbClient dbClient;

        public CeTaskSubmitToInsertedCeQueueDto(DbSession dbSession, DbClient dbClient) {
            this.dbSession = dbSession;
            this.dbClient = dbClient;
        }

        @Nonnull
        public CeQueueDto apply(@Nonnull CeTaskSubmit submission) {
            CeQueueDto dto = new CeQueueDto();
            dto.setUuid(submission.getUuid());
            dto.setTaskType(submission.getType());
            dto.setComponentUuid(submission.getComponentUuid());
            dto.setStatus(CeQueueDto.Status.PENDING);
            dto.setSubmitterLogin(submission.getSubmitterLogin());
            dto.setStartedAt(null);
            this.dbClient.ceQueueDao().insert(this.dbSession, dto);
            return dto;
        }
    }

    private static class CeQueueDtoToCeTask
    implements Function<CeQueueDto, CeTask> {
        private final String defaultOrganizationUuid;
        private final Map<String, ComponentDto> componentDtoByUuid;

        public CeQueueDtoToCeTask(String defaultOrganizationUuid) {
            this(defaultOrganizationUuid, Collections.emptyMap());
        }

        public CeQueueDtoToCeTask(String defaultOrganizationUuid, Map<String, ComponentDto> componentDtoByUuid) {
            this.defaultOrganizationUuid = Objects.requireNonNull(defaultOrganizationUuid, "defaultOrganizationUuid can't be null");
            this.componentDtoByUuid = componentDtoByUuid;
        }

        @Nonnull
        public CeTask apply(@Nonnull CeQueueDto dto) {
            CeTask.Builder builder = new CeTask.Builder();
            builder.setUuid(dto.getUuid());
            builder.setType(dto.getTaskType());
            builder.setSubmitterLogin(dto.getSubmitterLogin());
            String componentUuid = dto.getComponentUuid();
            if (componentUuid != null) {
                builder.setComponentUuid(componentUuid);
                ComponentDto component = this.componentDtoByUuid.get(componentUuid);
                if (component != null) {
                    builder.setOrganizationUuid(component.getOrganizationUuid());
                    builder.setComponentKey(component.getDbKey());
                    builder.setComponentName(component.name());
                }
            }
            if (!builder.hasOrganizationUuid()) {
                builder.setOrganizationUuid(this.defaultOrganizationUuid);
            }
            return builder.build();
        }
    }
}

