/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.storage;

import com.google.common.base.Preconditions;
import com.persistit.Exchange;
import com.persistit.Persistit;
import com.persistit.Volume;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.ValueCoder;
import com.persistit.exception.PersistitException;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.Startable;
import org.sonar.api.batch.ScannerSide;
import org.sonar.scanner.storage.Storage;
import org.sonar.scanner.storage.StoragesManager;

@ScannerSide
public class Storages
implements Startable {
    private final Map<String, Exchange> cacheMap = new HashMap<String, Exchange>();
    private Persistit persistit;
    private Volume volume;

    public Storages(StoragesManager storagesManager) {
        this.persistit = storagesManager.persistit();
        this.doStart();
    }

    public void start() {
    }

    private void doStart() {
        try {
            this.persistit.flush();
            this.volume = this.persistit.createTemporaryVolume();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to create a cache volume", e);
        }
    }

    public void registerValueCoder(Class<?> clazz, ValueCoder coder) {
        CoderManager cm = this.persistit.getCoderManager();
        cm.registerValueCoder(clazz, coder);
    }

    public <V> Storage<V> createCache(String cacheName) {
        Preconditions.checkState((this.volume != null && this.volume.isOpened() ? 1 : 0) != 0, (Object)"Caches are not initialized");
        Preconditions.checkState((!this.cacheMap.containsKey(cacheName) ? 1 : 0) != 0, (String)"Cache is already created: %s", (Object[])new Object[]{cacheName});
        try {
            Exchange exchange = this.persistit.getExchange(this.volume, cacheName, true);
            exchange.setMaximumValueSize(0x4000000);
            Storage cache = new Storage(cacheName, exchange);
            this.cacheMap.put(cacheName, exchange);
            return cache;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to create cache: " + cacheName, e);
        }
    }

    public void stop() {
        for (Map.Entry<String, Exchange> e : this.cacheMap.entrySet()) {
            this.persistit.releaseExchange(e.getValue());
        }
        this.cacheMap.clear();
        if (this.volume != null) {
            try {
                this.volume.close();
                this.volume.delete();
            }
            catch (PersistitException e) {
                throw new IllegalStateException("Fail to close caches", e);
            }
            this.volume = null;
        }
    }
}

