/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.metric.ScannerMetrics;
import org.sonar.duplications.internal.pmd.PmdBlockChunker;
import org.sonar.scanner.cpd.deprecated.DefaultCpdBlockIndexer;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;
import org.sonar.scanner.issue.ModuleIssues;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.report.ScannerReportUtils;
import org.sonar.scanner.repository.ContextPropertiesCache;
import org.sonar.scanner.scan.measure.MeasureCache;

public class DefaultSensorStorage
implements SensorStorage {
    private static final Logger LOG = Loggers.get(DefaultSensorStorage.class);
    private static final List<String> DEPRECATED_METRICS_KEYS = Arrays.asList("dsm", "package_cycles", "package_edges_weight", "package_feedback_edges", "package_tangle_index", "package_tangles", "file_cycles", "file_edges_weight", "file_feedback_edges", "file_tangle_index", "file_tangles", "commented_out_code_lines");
    private static final List<String> PLATFORM_METRICS_KEYS = Arrays.asList("lines", "test_success_density", "public_documented_api_density");
    private final MetricFinder metricFinder;
    private final ModuleIssues moduleIssues;
    private final ReportPublisher reportPublisher;
    private final MeasureCache measureCache;
    private final SonarCpdBlockIndex index;
    private final ContextPropertiesCache contextPropertiesCache;
    private final Configuration settings;
    private final ScannerMetrics scannerMetrics;
    private final Map<Metric<?>, Metric<?>> deprecatedCoverageMetricMapping = new HashMap();
    private final Set<Metric<?>> coverageMetrics = new HashSet();
    private final Set<Metric<?>> byLineMetrics = new HashSet();
    private final Set<String> alreadyLogged = new HashSet<String>();

    public DefaultSensorStorage(MetricFinder metricFinder, ModuleIssues moduleIssues, Configuration settings, ReportPublisher reportPublisher, MeasureCache measureCache, SonarCpdBlockIndex index, ContextPropertiesCache contextPropertiesCache, ScannerMetrics scannerMetrics) {
        this.metricFinder = metricFinder;
        this.moduleIssues = moduleIssues;
        this.settings = settings;
        this.reportPublisher = reportPublisher;
        this.measureCache = measureCache;
        this.index = index;
        this.contextPropertiesCache = contextPropertiesCache;
        this.scannerMetrics = scannerMetrics;
        this.coverageMetrics.add((Metric<?>)CoreMetrics.UNCOVERED_LINES);
        this.coverageMetrics.add((Metric<?>)CoreMetrics.LINES_TO_COVER);
        this.coverageMetrics.add((Metric<?>)CoreMetrics.UNCOVERED_CONDITIONS);
        this.coverageMetrics.add((Metric<?>)CoreMetrics.CONDITIONS_TO_COVER);
        this.coverageMetrics.add((Metric<?>)CoreMetrics.CONDITIONS_BY_LINE);
        this.coverageMetrics.add((Metric<?>)CoreMetrics.COVERED_CONDITIONS_BY_LINE);
        this.coverageMetrics.add((Metric<?>)CoreMetrics.COVERAGE_LINE_HITS_DATA);
        this.byLineMetrics.add((Metric<?>)CoreMetrics.COVERAGE_LINE_HITS_DATA);
        this.byLineMetrics.add((Metric<?>)CoreMetrics.COVERED_CONDITIONS_BY_LINE);
        this.byLineMetrics.add((Metric<?>)CoreMetrics.CONDITIONS_BY_LINE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_COVERAGE, (Metric<?>)CoreMetrics.COVERAGE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_LINE_COVERAGE, (Metric<?>)CoreMetrics.LINE_COVERAGE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_BRANCH_COVERAGE, (Metric<?>)CoreMetrics.BRANCH_COVERAGE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_UNCOVERED_LINES, (Metric<?>)CoreMetrics.UNCOVERED_LINES);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_LINES_TO_COVER, (Metric<?>)CoreMetrics.LINES_TO_COVER);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_UNCOVERED_CONDITIONS, (Metric<?>)CoreMetrics.UNCOVERED_CONDITIONS);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_CONDITIONS_TO_COVER, (Metric<?>)CoreMetrics.CONDITIONS_TO_COVER);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_CONDITIONS_BY_LINE, (Metric<?>)CoreMetrics.CONDITIONS_BY_LINE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, (Metric<?>)CoreMetrics.COVERED_CONDITIONS_BY_LINE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, (Metric<?>)CoreMetrics.COVERAGE_LINE_HITS_DATA);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_COVERAGE, (Metric<?>)CoreMetrics.COVERAGE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_LINE_COVERAGE, (Metric<?>)CoreMetrics.LINE_COVERAGE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_BRANCH_COVERAGE, (Metric<?>)CoreMetrics.BRANCH_COVERAGE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_UNCOVERED_LINES, (Metric<?>)CoreMetrics.UNCOVERED_LINES);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_LINES_TO_COVER, (Metric<?>)CoreMetrics.LINES_TO_COVER);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, (Metric<?>)CoreMetrics.UNCOVERED_CONDITIONS);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_CONDITIONS_TO_COVER, (Metric<?>)CoreMetrics.CONDITIONS_TO_COVER);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_CONDITIONS_BY_LINE, (Metric<?>)CoreMetrics.CONDITIONS_BY_LINE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE, (Metric<?>)CoreMetrics.COVERED_CONDITIONS_BY_LINE);
        this.deprecatedCoverageMetricMapping.put((Metric<?>)CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, (Metric<?>)CoreMetrics.COVERAGE_LINE_HITS_DATA);
    }

    public void store(Measure newMeasure) {
        if (newMeasure.inputComponent() instanceof DefaultInputFile) {
            ((DefaultInputFile)newMeasure.inputComponent()).setPublished(true);
        }
        this.saveMeasure(newMeasure.inputComponent(), (DefaultMeasure)newMeasure);
    }

    private void logOnce(String metricKey, String msg, Object ... params) {
        if (this.alreadyLogged.add(metricKey)) {
            LOG.warn(msg, params);
        }
    }

    public void saveMeasure(InputComponent component, DefaultMeasure<?> measure) {
        DefaultMeasure measureToSave;
        if (component.isFile()) {
            ((DefaultInputFile)component).setPublished(true);
        }
        if (DefaultSensorStorage.isDeprecatedMetric(measure.metric().key())) {
            this.logOnce(measure.metric().key(), "Metric '{}' is deprecated. Provided value is ignored.", measure.metric().key());
            return;
        }
        Metric<?> metric = this.metricFinder.findByKey(measure.metric().key());
        if (metric == null) {
            throw new UnsupportedOperationException("Unknown metric: " + measure.metric().key());
        }
        if (!measure.isFromCore() && DefaultSensorStorage.isPlatformMetric(measure.metric().key())) {
            this.logOnce(measure.metric().key(), "Metric '{}' is an internal metric computed by SonarQube. Provided value is ignored.", measure.metric().key());
            return;
        }
        if (this.deprecatedCoverageMetricMapping.containsKey(metric)) {
            metric = this.deprecatedCoverageMetricMapping.get(metric);
            measureToSave = new DefaultMeasure().forMetric(metric).on(measure.inputComponent()).withValue(measure.value());
        } else {
            measureToSave = measure;
        }
        if (!this.scannerMetrics.getMetrics().contains(metric)) {
            throw new UnsupportedOperationException("Metric '" + metric.key() + "' should not be computed by a Sensor");
        }
        if (this.coverageMetrics.contains(metric)) {
            this.logOnce(metric.key(), "Coverage measure for metric '{}' should not be saved directly by a Sensor. Plugin should be updated to use SensorContext::newCoverage instead.", metric.key());
            if (!component.isFile()) {
                throw new UnsupportedOperationException("Saving coverage measure is only allowed on files. Attempt to save '" + metric.key() + "' on '" + component.key() + "'");
            }
            if (((DefaultInputFile)component).isExcludedForCoverage()) {
                return;
            }
            this.saveCoverageMetricInternal((InputFile)component, metric, measureToSave);
        } else {
            if (this.measureCache.contains(component.key(), metric.key())) {
                throw new UnsupportedOperationException("Can not add the same measure twice on " + component + ": " + measure);
            }
            this.measureCache.put(component.key(), metric.key(), measureToSave);
        }
    }

    private void saveCoverageMetricInternal(InputFile file, Metric<?> metric, DefaultMeasure<?> measure) {
        if (this.isLineMetrics(metric)) {
            DefaultSensorStorage.validateCoverageMeasure((String)((Object)measure.value()), file);
            DefaultMeasure<?> previousMeasure = this.measureCache.byMetric(file.key(), metric.key());
            if (previousMeasure != null) {
                this.measureCache.put(file.key(), metric.key(), new DefaultMeasure().forMetric(metric).withValue((Serializable)((Object)DefaultSensorStorage.mergeCoverageLineMetric(metric, (String)((Object)previousMeasure.value()), (String)((Object)measure.value())))));
            } else {
                this.measureCache.put(file.key(), metric.key(), measure);
            }
        } else {
            this.measureCache.put(file.key(), metric.key(), measure);
        }
    }

    static String mergeCoverageLineMetric(Metric<?> metric, String value1, String value2) {
        Map data1 = KeyValueFormat.parseIntInt((String)value1);
        Map data2 = KeyValueFormat.parseIntInt((String)value2);
        if (metric.key().equals("coverage_line_hits_data")) {
            return KeyValueFormat.format((Map)Stream.of(data1, data2).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, TreeMap::new)));
        }
        return KeyValueFormat.format((Map)Stream.of(data1, data2).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::max, TreeMap::new)));
    }

    public static boolean isDeprecatedMetric(String metricKey) {
        return DEPRECATED_METRICS_KEYS.contains(metricKey);
    }

    public static boolean isPlatformMetric(String metricKey) {
        return PLATFORM_METRICS_KEYS.contains(metricKey);
    }

    private boolean isLineMetrics(Metric<?> metric) {
        return this.byLineMetrics.contains(metric);
    }

    public static void validateCoverageMeasure(String value, InputFile inputFile) {
        Map m = KeyValueFormat.parseIntInt((String)value);
        DefaultSensorStorage.validatePositiveLine(m, inputFile.toString());
        DefaultSensorStorage.validateMaxLine(m, inputFile);
    }

    private static void validateMaxLine(Map<Integer, Integer> m, InputFile inputFile) {
        int maxLine = inputFile.lines();
        for (int line : m.keySet()) {
            if (line <= maxLine) continue;
            throw new IllegalStateException(String.format("Can't create measure for line %d for file '%s' with %d lines", line, inputFile, maxLine));
        }
    }

    private static void validatePositiveLine(Map<Integer, Integer> m, String filePath) {
        for (int l : m.keySet()) {
            if (l > 0) continue;
            throw new IllegalStateException(String.format("Measure with line %d for file '%s' must be > 0", l, filePath));
        }
    }

    public void store(Issue issue) {
        if (issue.primaryLocation().inputComponent() instanceof DefaultInputFile) {
            ((DefaultInputFile)issue.primaryLocation().inputComponent()).setPublished(true);
        }
        this.moduleIssues.initAndAddIssue(issue);
    }

    public void store(DefaultHighlighting highlighting) {
        ScannerReportWriter writer = this.reportPublisher.getWriter();
        DefaultInputFile inputFile = (DefaultInputFile)highlighting.inputFile();
        inputFile.setPublished(true);
        int componentRef = inputFile.batchId();
        if (writer.hasComponentData(FileStructure.Domain.SYNTAX_HIGHLIGHTINGS, componentRef)) {
            throw new UnsupportedOperationException("Trying to save highlighting twice for the same file is not supported: " + inputFile);
        }
        ScannerReport.SyntaxHighlightingRule.Builder builder = ScannerReport.SyntaxHighlightingRule.newBuilder();
        ScannerReport.TextRange.Builder rangeBuilder = ScannerReport.TextRange.newBuilder();
        writer.writeComponentSyntaxHighlighting(componentRef, (Iterable)highlighting.getSyntaxHighlightingRuleSet().stream().map(input -> {
            builder.setRange(rangeBuilder.setStartLine(input.range().start().line()).setStartOffset(input.range().start().lineOffset()).setEndLine(input.range().end().line()).setEndOffset(input.range().end().lineOffset()).build());
            builder.setType(ScannerReportUtils.toProtocolType(input.getTextType()));
            return builder.build();
        }).collect(Collectors.toList()));
    }

    public void store(DefaultSymbolTable symbolTable) {
        ScannerReportWriter writer = this.reportPublisher.getWriter();
        DefaultInputFile inputFile = (DefaultInputFile)symbolTable.inputFile();
        inputFile.setPublished(true);
        int componentRef = inputFile.batchId();
        if (writer.hasComponentData(FileStructure.Domain.SYMBOLS, componentRef)) {
            throw new UnsupportedOperationException("Trying to save symbol table twice for the same file is not supported: " + symbolTable.inputFile().absolutePath());
        }
        ScannerReport.Symbol.Builder builder = ScannerReport.Symbol.newBuilder();
        ScannerReport.TextRange.Builder rangeBuilder = ScannerReport.TextRange.newBuilder();
        writer.writeComponentSymbols(componentRef, (Iterable)symbolTable.getReferencesBySymbol().entrySet().stream().map(input -> {
            builder.clear();
            rangeBuilder.clear();
            TextRange declaration = (TextRange)input.getKey();
            builder.setDeclaration(rangeBuilder.setStartLine(declaration.start().line()).setStartOffset(declaration.start().lineOffset()).setEndLine(declaration.end().line()).setEndOffset(declaration.end().lineOffset()).build());
            for (TextRange reference : (Set)input.getValue()) {
                builder.addReference(rangeBuilder.setStartLine(reference.start().line()).setStartOffset(reference.start().lineOffset()).setEndLine(reference.end().line()).setEndOffset(reference.end().lineOffset()).build());
            }
            return builder.build();
        }).collect(Collectors.toList()));
    }

    public void store(DefaultCoverage defaultCoverage) {
        DefaultInputFile inputFile = (DefaultInputFile)defaultCoverage.inputFile();
        inputFile.setPublished(true);
        if (defaultCoverage.linesToCover() > 0) {
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.LINES_TO_COVER, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.LINES_TO_COVER).withValue((Serializable)Integer.valueOf(defaultCoverage.linesToCover())));
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.UNCOVERED_LINES, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.UNCOVERED_LINES).withValue((Serializable)Integer.valueOf(defaultCoverage.linesToCover() - defaultCoverage.coveredLines())));
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.COVERAGE_LINE_HITS_DATA, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.COVERAGE_LINE_HITS_DATA).withValue((Serializable)((Object)KeyValueFormat.format((Map)defaultCoverage.hitsByLine()))));
        }
        if (defaultCoverage.conditions() > 0) {
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.CONDITIONS_TO_COVER, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.CONDITIONS_TO_COVER).withValue((Serializable)Integer.valueOf(defaultCoverage.conditions())));
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.UNCOVERED_CONDITIONS, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.UNCOVERED_CONDITIONS).withValue((Serializable)Integer.valueOf(defaultCoverage.conditions() - defaultCoverage.coveredConditions())));
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.COVERED_CONDITIONS_BY_LINE, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.COVERED_CONDITIONS_BY_LINE).withValue((Serializable)((Object)KeyValueFormat.format((Map)defaultCoverage.coveredConditionsByLine()))));
            this.saveCoverageMetricInternal((InputFile)inputFile, (Metric<?>)CoreMetrics.CONDITIONS_BY_LINE, (DefaultMeasure<?>)new DefaultMeasure().forMetric((Metric)CoreMetrics.CONDITIONS_BY_LINE).withValue((Serializable)((Object)KeyValueFormat.format((Map)defaultCoverage.conditionsByLine()))));
        }
    }

    public void store(DefaultCpdTokens defaultCpdTokens) {
        DefaultInputFile inputFile = (DefaultInputFile)defaultCpdTokens.inputFile();
        inputFile.setPublished(true);
        PmdBlockChunker blockChunker = new PmdBlockChunker(this.getBlockSize(inputFile.language()));
        List blocks = blockChunker.chunk(inputFile.key(), defaultCpdTokens.getTokenLines());
        this.index.insert((InputFile)inputFile, blocks);
    }

    @VisibleForTesting
    int getBlockSize(String languageKey) {
        return this.settings.getInt("sonar.cpd." + languageKey + ".minimumLines").orElse(DefaultCpdBlockIndexer.getDefaultBlockSize(languageKey));
    }

    public void store(AnalysisError analysisError) {
        ((DefaultInputFile)analysisError.inputFile()).setPublished(true);
    }

    public void storeProperty(String key, String value) {
        this.contextPropertiesCache.put(key, value);
    }
}

