/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.measure;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.measures.Metric;
import org.sonar.scanner.repository.MetricsRepository;

@ThreadSafe
public class DefaultMetricFinder
implements MetricFinder {
    private Map<String, Metric<Serializable>> metricsByKey;

    public DefaultMetricFinder(MetricsRepository metricsRepository) {
        LinkedHashMap<String, org.sonar.api.measures.Metric> metrics = new LinkedHashMap<String, org.sonar.api.measures.Metric>();
        for (org.sonar.api.measures.Metric metric : metricsRepository.metrics()) {
            metrics.put(metric.key(), new Metric.Builder(metric.key(), metric.key(), metric.getType()).create());
        }
        this.metricsByKey = Collections.unmodifiableMap(metrics);
    }

    public Metric<Serializable> findByKey(String key) {
        return this.metricsByKey.get(key);
    }

    public Collection<Metric<Serializable>> findAll(List<String> metricKeys) {
        LinkedList result = Lists.newLinkedList();
        for (String metricKey : metricKeys) {
            Metric<Serializable> metric = this.findByKey(metricKey);
            if (metric == null) continue;
            result.add(metric);
        }
        return result;
    }

    public Collection<Metric<Serializable>> findAll() {
        return this.metricsByKey.values();
    }
}

