/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.config.DefaultConfiguration;

@ScannerSide
@Immutable
public class ModuleFileSystemInitializer {
    private static final Logger LOG = Loggers.get(ModuleFileSystemInitializer.class);
    private final List<Path> sourceDirsOrFiles;
    private final List<Path> testDirsOrFiles;
    private final Charset encoding;

    public ModuleFileSystemInitializer(DefaultInputModule inputModule) {
        ModuleFileSystemInitializer.logDir("Base dir: ", inputModule.getBaseDir());
        ModuleFileSystemInitializer.logDir("Working dir: ", inputModule.getWorkDir());
        this.sourceDirsOrFiles = ModuleFileSystemInitializer.initSources(inputModule, "sonar.sources", "Source paths: ");
        this.testDirsOrFiles = ModuleFileSystemInitializer.initSources(inputModule, "sonar.tests", "Test paths: ");
        this.encoding = ModuleFileSystemInitializer.initEncoding(inputModule);
    }

    private static List<Path> initSources(DefaultInputModule module, String propertyKey, String logLabel) {
        ArrayList<Path> result = new ArrayList<Path>();
        PathResolver pathResolver = new PathResolver();
        String srcPropValue = (String)module.properties().get(propertyKey);
        if (srcPropValue != null) {
            for (String sourcePath : DefaultConfiguration.parseAsCsv(propertyKey, srcPropValue)) {
                File dirOrFile = pathResolver.relativeFile(module.getBaseDir().toFile(), sourcePath);
                if (!dirOrFile.exists()) continue;
                result.add(dirOrFile.toPath());
            }
        }
        ModuleFileSystemInitializer.logPaths(logLabel, module.getBaseDir(), result);
        return result;
    }

    private static Charset initEncoding(DefaultInputModule module) {
        Charset result;
        String encodingStr = (String)module.properties().get("sonar.sourceEncoding");
        if (StringUtils.isNotEmpty((String)encodingStr)) {
            result = Charset.forName(StringUtils.trim((String)encodingStr));
            LOG.info("Source encoding: {}, default locale: {}", (Object)result.displayName(), (Object)Locale.getDefault());
        } else {
            result = Charset.defaultCharset();
            LOG.warn("Source encoding is platform dependent ({}), default locale: {}", (Object)result.displayName(), (Object)Locale.getDefault());
        }
        return result;
    }

    List<Path> sources() {
        return this.sourceDirsOrFiles;
    }

    List<Path> tests() {
        return this.testDirsOrFiles;
    }

    public Charset defaultEncoding() {
        return this.encoding;
    }

    private static void logPaths(String label, Path baseDir, List<Path> paths) {
        if (!paths.isEmpty()) {
            StringBuilder sb = new StringBuilder(label);
            Iterator<Path> it = paths.iterator();
            while (it.hasNext()) {
                Path file = it.next();
                Optional relativePathToBaseDir = PathResolver.relativize((Path)baseDir, (Path)file);
                if (!relativePathToBaseDir.isPresent()) {
                    sb.append(file);
                } else if (StringUtils.isBlank((String)((String)relativePathToBaseDir.get()))) {
                    sb.append(".");
                } else {
                    sb.append((String)relativePathToBaseDir.get());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            LOG.info(sb.toString());
        }
    }

    private static void logDir(String label, @Nullable Path dir) {
        if (dir != null) {
            LOG.info(label + dir.toAbsolutePath().toString());
        }
    }
}

