/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.collect.ImmutableMultimap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.scan.filesystem.PathResolver;

@Immutable
public class DefaultInputModuleHierarchy
implements InputModuleHierarchy {
    private final DefaultInputModule root;
    private final Map<DefaultInputModule, DefaultInputModule> parents;
    private final ImmutableMultimap<DefaultInputModule, DefaultInputModule> children;

    public DefaultInputModuleHierarchy(DefaultInputModule parent, DefaultInputModule child) {
        this(Collections.singletonMap(child, parent));
    }

    public DefaultInputModuleHierarchy(DefaultInputModule root) {
        this.children = new ImmutableMultimap.Builder().build();
        this.parents = Collections.emptyMap();
        this.root = root;
    }

    public DefaultInputModuleHierarchy(Map<DefaultInputModule, DefaultInputModule> parents) {
        ImmutableMultimap.Builder childrenBuilder = new ImmutableMultimap.Builder();
        for (Map.Entry<DefaultInputModule, DefaultInputModule> e : parents.entrySet()) {
            childrenBuilder.put((Object)e.getValue(), (Object)e.getKey());
        }
        this.children = childrenBuilder.build();
        this.parents = Collections.unmodifiableMap(new HashMap<DefaultInputModule, DefaultInputModule>(parents));
        this.root = DefaultInputModuleHierarchy.findRoot(parents);
    }

    private static DefaultInputModule findRoot(Map<DefaultInputModule, DefaultInputModule> parents) {
        DefaultInputModule r = null;
        for (DefaultInputModule parent : parents.values()) {
            if (parents.containsKey(parent)) continue;
            if (r != null && r != parent) {
                throw new IllegalStateException(String.format("Found two modules without parent: '%s' and '%s'", r.key(), parent.key()));
            }
            r = parent;
        }
        if (r == null) {
            throw new IllegalStateException("Found no root module");
        }
        return r;
    }

    public DefaultInputModule root() {
        return this.root;
    }

    public Collection<DefaultInputModule> children(InputModule component) {
        return this.children.get((Object)((DefaultInputModule)component));
    }

    public DefaultInputModule parent(InputModule component) {
        return this.parents.get(component);
    }

    public boolean isRoot(InputModule module) {
        return this.root.equals((Object)module);
    }

    @CheckForNull
    public String relativePath(InputModule module) {
        DefaultInputModule parent = this.parent(module);
        if (parent == null) {
            return null;
        }
        DefaultInputModule inputModule = (DefaultInputModule)module;
        Path parentBaseDir = parent.getBaseDir();
        Path moduleBaseDir = inputModule.getBaseDir();
        return PathResolver.relativize((Path)parentBaseDir, (Path)moduleBaseDir).orElse(null);
    }
}

