/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.utils.SonarException;

public class RulesProfileWrapper
extends RulesProfile {
    private static final Logger LOG = LoggerFactory.getLogger(RulesProfileWrapper.class);
    private static final String DEPRECATED_USAGE_MESSAGE = "Please update your plugin to support multi-language analysis";
    private final Collection<RulesProfile> profiles;
    private final RulesProfile singleLanguageProfile;

    public RulesProfileWrapper(Collection<RulesProfile> profiles) {
        this.profiles = profiles;
        this.singleLanguageProfile = null;
    }

    public RulesProfileWrapper(RulesProfile profile) {
        this.profiles = Collections.singletonList(profile);
        this.singleLanguageProfile = profile;
    }

    public Integer getId() {
        return this.getSingleProfileOrFail().getId();
    }

    private RulesProfile getSingleProfileOrFail() {
        if (this.singleLanguageProfile == null) {
            throw new IllegalStateException(DEPRECATED_USAGE_MESSAGE);
        }
        return this.singleLanguageProfile;
    }

    public String getName() {
        return this.singleLanguageProfile != null ? this.singleLanguageProfile.getName() : "SonarQube";
    }

    public String getLanguage() {
        if (this.singleLanguageProfile == null) {
            LOG.debug(DEPRECATED_USAGE_MESSAGE, (Throwable)new SonarException(DEPRECATED_USAGE_MESSAGE));
            return "";
        }
        return this.singleLanguageProfile.getLanguage();
    }

    public List<ActiveRule> getActiveRules() {
        ArrayList<ActiveRule> activeRules = new ArrayList<ActiveRule>();
        for (RulesProfile profile : this.profiles) {
            activeRules.addAll(profile.getActiveRules());
        }
        return activeRules;
    }

    public ActiveRule getActiveRule(String repositoryKey, String ruleKey) {
        for (RulesProfile profile : this.profiles) {
            ActiveRule activeRule = profile.getActiveRule(repositoryKey, ruleKey);
            if (activeRule == null) continue;
            return activeRule;
        }
        return null;
    }

    public List<ActiveRule> getActiveRulesByRepository(String repositoryKey) {
        ArrayList<ActiveRule> activeRules = new ArrayList<ActiveRule>();
        for (RulesProfile profile : this.profiles) {
            activeRules.addAll(profile.getActiveRulesByRepository(repositoryKey));
        }
        return activeRules;
    }

    public List<ActiveRule> getActiveRules(boolean acceptDisabledRules) {
        ArrayList<ActiveRule> activeRules = new ArrayList<ActiveRule>();
        for (RulesProfile profile : this.profiles) {
            activeRules.addAll(profile.getActiveRules(acceptDisabledRules));
        }
        return activeRules;
    }

    public ActiveRule getActiveRule(Rule rule) {
        for (RulesProfile profile : this.profiles) {
            ActiveRule activeRule = profile.getActiveRule(rule);
            if (activeRule == null) continue;
            return activeRule;
        }
        return null;
    }

    public Boolean getDefaultProfile() {
        return this.getSingleProfileOrFail().getDefaultProfile();
    }
}

