/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.repository.QualityProfileLoader;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.QualityProfiles;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;

public class DefaultQualityProfileLoader
implements QualityProfileLoader {
    private static final String WS_URL = "/api/qualityprofiles/search.protobuf";
    private final Configuration settings;
    private final ScannerWsClient wsClient;

    public DefaultQualityProfileLoader(Configuration settings, ScannerWsClient wsClient) {
        this.settings = settings;
        this.wsClient = wsClient;
    }

    @Override
    public List<QualityProfiles.SearchWsResponse.QualityProfile> loadDefault(@Nullable String profileName) {
        StringBuilder url = new StringBuilder("/api/qualityprofiles/search.protobuf?defaults=true");
        return this.loadAndOverrideIfNeeded(profileName, url);
    }

    @Override
    public List<QualityProfiles.SearchWsResponse.QualityProfile> load(String projectKey, @Nullable String profileName) {
        StringBuilder url = new StringBuilder("/api/qualityprofiles/search.protobuf?projectKey=").append(ScannerUtils.encodeForUrl(projectKey));
        return this.loadAndOverrideIfNeeded(profileName, url);
    }

    private List<QualityProfiles.SearchWsResponse.QualityProfile> loadAndOverrideIfNeeded(@Nullable String profileName, StringBuilder url) {
        this.getOrganizationKey().ifPresent(k -> url.append("&organization=").append(ScannerUtils.encodeForUrl(k)));
        Map<String, QualityProfiles.SearchWsResponse.QualityProfile> result = this.call(url.toString());
        if (profileName != null) {
            StringBuilder urlForName = new StringBuilder("/api/qualityprofiles/search.protobuf?profileName=");
            urlForName.append(ScannerUtils.encodeForUrl(profileName));
            this.getOrganizationKey().ifPresent(k -> urlForName.append("&organization=").append(ScannerUtils.encodeForUrl(k)));
            result.putAll(this.call(urlForName.toString()));
        }
        if (result.isEmpty()) {
            throw MessageException.of((String)"No quality profiles have been found, you probably don't have any language plugin installed.");
        }
        return new ArrayList<QualityProfiles.SearchWsResponse.QualityProfile>(result.values());
    }

    private Optional<String> getOrganizationKey() {
        return this.settings.get("sonar.organization");
    }

    private Map<String, QualityProfiles.SearchWsResponse.QualityProfile> call(String url) {
        QualityProfiles.SearchWsResponse profiles;
        GetRequest getRequest = new GetRequest(url);
        InputStream is = this.wsClient.call((WsRequest)getRequest).contentStream();
        try {
            profiles = QualityProfiles.SearchWsResponse.parseFrom((InputStream)is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load quality profiles", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        List profilesList = profiles.getProfilesList();
        return profilesList.stream().collect(Collectors.toMap(QualityProfiles.SearchWsResponse.QualityProfile::getLanguage, Function.identity(), DefaultQualityProfileLoader.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

