/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.measure.MeasureCache;

public class CoveragePublisher
implements ReportPublisherStep {
    private final InputComponentStore componentStore;
    private final MeasureCache measureCache;

    public CoveragePublisher(InputComponentStore componentStore, MeasureCache measureCache) {
        this.componentStore = componentStore;
        this.measureCache = measureCache;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        for (DefaultInputFile inputFile : this.componentStore.allFilesToPublish()) {
            LinkedHashMap<Integer, ScannerReport.LineCoverage.Builder> coveragePerLine = new LinkedHashMap<Integer, ScannerReport.LineCoverage.Builder>();
            int lineCount = inputFile.lines();
            this.applyLineMeasure(inputFile.key(), lineCount, "coverage_line_hits_data", coveragePerLine, (value, builder) -> builder.setHits(Integer.parseInt(value) > 0));
            this.applyLineMeasure(inputFile.key(), lineCount, "conditions_by_line", coveragePerLine, (value, builder) -> builder.setConditions(Integer.parseInt(value)));
            this.applyLineMeasure(inputFile.key(), lineCount, "covered_conditions_by_line", coveragePerLine, (value, builder) -> builder.setCoveredConditions(Integer.parseInt(value)));
            writer.writeComponentCoverage(inputFile.batchId(), Iterables.transform(coveragePerLine.values(), (Function)BuildCoverage.INSTANCE));
        }
    }

    void applyLineMeasure(String inputFileKey, int lineCount, String metricKey, Map<Integer, ScannerReport.LineCoverage.Builder> coveragePerLine, MeasureOperation op) {
        DefaultMeasure<?> measure = this.measureCache.byMetric(inputFileKey, metricKey);
        if (measure != null) {
            Map lineMeasures = KeyValueFormat.parseIntString((String)((String)((Object)measure.value())));
            for (Map.Entry lineMeasure : lineMeasures.entrySet()) {
                String value;
                int lineIdx = (Integer)lineMeasure.getKey();
                if (lineIdx > lineCount || !StringUtils.isNotEmpty((String)(value = (String)lineMeasure.getValue()))) continue;
                ScannerReport.LineCoverage.Builder coverageBuilder = coveragePerLine.get(lineIdx);
                if (coverageBuilder == null) {
                    coverageBuilder = ScannerReport.LineCoverage.newBuilder();
                    coverageBuilder.setLine(lineIdx);
                    coveragePerLine.put(lineIdx, coverageBuilder);
                }
                op.apply(value, coverageBuilder);
            }
        }
    }

    private static enum BuildCoverage implements Function<ScannerReport.LineCoverage.Builder, ScannerReport.LineCoverage>
    {
        INSTANCE;


        public ScannerReport.LineCoverage apply(@Nonnull ScannerReport.LineCoverage.Builder input) {
            return input.build();
        }
    }

    static interface MeasureOperation {
        public void apply(String var1, ScannerReport.LineCoverage.Builder var2);
    }
}

