/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.profiling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.TimeUtils;
import org.sonar.scanner.profiling.PhasesSumUpTimeProfiler;

public abstract class AbstractTimeProfiling {
    private final long startTime;
    private long totalTime;
    private System2 system;

    public AbstractTimeProfiling(System2 system) {
        this.system = system;
        this.startTime = system.now();
    }

    protected System2 system() {
        return this.system;
    }

    public long startTime() {
        return this.startTime;
    }

    public void stop() {
        this.totalTime = this.system.now() - this.startTime;
    }

    public long totalTime() {
        return this.totalTime;
    }

    public String totalTimeAsString() {
        return TimeUtils.formatDuration((long)this.totalTime);
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    protected void add(AbstractTimeProfiling other) {
        this.setTotalTime(this.totalTime() + other.totalTime());
    }

    static <G extends AbstractTimeProfiling> Map<Object, G> sortByDescendingTotalTime(Map<?, G> unsorted) {
        ArrayList entries = new ArrayList(unsorted.entrySet());
        Collections.sort(entries, (o1, o2) -> Long.valueOf(((AbstractTimeProfiling)o2.getValue()).totalTime()).compareTo(((AbstractTimeProfiling)o1.getValue()).totalTime()));
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    static <G extends AbstractTimeProfiling> List<G> truncate(Collection<G> sortedList) {
        int maxSize = 10;
        ArrayList<AbstractTimeProfiling> result = new ArrayList<AbstractTimeProfiling>(maxSize);
        int i = 0;
        for (AbstractTimeProfiling item : sortedList) {
            if (i >= maxSize || item.totalTime() == 0L) {
                return result;
            }
            ++i;
            result.add(item);
        }
        return result;
    }

    protected void println(String msg) {
        PhasesSumUpTimeProfiler.println(msg);
    }

    protected void println(String text, @Nullable Double percent, AbstractTimeProfiling phaseProfiling) {
        PhasesSumUpTimeProfiler.println(text, percent, phaseProfiling);
    }

    protected void println(String text, AbstractTimeProfiling phaseProfiling) {
        this.println(text, null, phaseProfiling);
    }
}

