/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputComponentTree;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.Tracker;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.scanner.analysis.DefaultAnalysisMode;
import org.sonar.scanner.issue.IssueTransformer;
import org.sonar.scanner.issue.tracking.IssueTrackingInput;
import org.sonar.scanner.issue.tracking.ServerIssueFromWs;
import org.sonar.scanner.issue.tracking.ServerIssueRepository;
import org.sonar.scanner.issue.tracking.ServerLineHashesLoader;
import org.sonar.scanner.issue.tracking.SourceHashHolder;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.repository.ProjectRepositories;

@ScannerSide
public class LocalIssueTracking {
    private final Tracker<TrackedIssue, ServerIssueFromWs> tracker;
    private final ServerLineHashesLoader lastLineHashes;
    private final ActiveRules activeRules;
    private final ServerIssueRepository serverIssueRepository;
    private final DefaultAnalysisMode mode;
    private final InputComponentTree componentTree;
    private boolean hasServerAnalysis;

    public LocalIssueTracking(Tracker<TrackedIssue, ServerIssueFromWs> tracker, ServerLineHashesLoader lastLineHashes, InputComponentTree componentTree, ActiveRules activeRules, ServerIssueRepository serverIssueRepository, ProjectRepositories projectRepositories, DefaultAnalysisMode mode) {
        this.tracker = tracker;
        this.lastLineHashes = lastLineHashes;
        this.componentTree = componentTree;
        this.serverIssueRepository = serverIssueRepository;
        this.mode = mode;
        this.activeRules = activeRules;
        this.hasServerAnalysis = projectRepositories.lastAnalysisDate() != null;
    }

    public void init() {
        if (this.hasServerAnalysis) {
            this.serverIssueRepository.load();
        }
    }

    public List<TrackedIssue> trackIssues(InputComponent component, Collection<ScannerReport.Issue> reportIssues, Date analysisDate) {
        LinkedList<TrackedIssue> trackedIssues = new LinkedList<TrackedIssue>();
        if (this.hasServerAnalysis) {
            Collection<ServerIssueFromWs> serverIssues = this.loadServerIssues(component);
            if (this.shouldCopyServerIssues(component)) {
                this.copyServerIssues(serverIssues, trackedIssues, component.key());
            } else {
                SourceHashHolder sourceHashHolder = this.loadSourceHashes(component);
                Collection<TrackedIssue> rIssues = IssueTransformer.toTrackedIssue(component, reportIssues, sourceHashHolder);
                Input<ServerIssueFromWs> baseIssues = LocalIssueTracking.createBaseInput(serverIssues, sourceHashHolder);
                Input<TrackedIssue> rawIssues = LocalIssueTracking.createRawInput(rIssues, sourceHashHolder);
                Tracking track = this.tracker.track(rawIssues, baseIssues);
                this.addUnmatchedFromServer(track.getUnmatchedBases(), trackedIssues, component.key());
                this.mergeMatched((Tracking<TrackedIssue, ServerIssueFromWs>)track, trackedIssues, rIssues);
                LocalIssueTracking.addUnmatchedFromReport(track.getUnmatchedRaws(), trackedIssues, analysisDate);
            }
        }
        if (this.hasServerAnalysis && this.componentTree.getParent(component) == null) {
            Preconditions.checkState((boolean)(component instanceof InputModule), (Object)("Object without parent is of type: " + component.getClass()));
            this.addIssuesOnDeletedComponents(trackedIssues, component.key());
        }
        return trackedIssues;
    }

    private static Input<ServerIssueFromWs> createBaseInput(Collection<ServerIssueFromWs> serverIssues, @Nullable SourceHashHolder sourceHashHolder) {
        List<Object> refHashes = sourceHashHolder != null && sourceHashHolder.getHashedReference() != null ? Arrays.asList(sourceHashHolder.getHashedReference().hashes()) : new ArrayList(0);
        return new IssueTrackingInput<ServerIssueFromWs>(serverIssues, refHashes);
    }

    private static Input<TrackedIssue> createRawInput(Collection<TrackedIssue> rIssues, @Nullable SourceHashHolder sourceHashHolder) {
        List<Object> baseHashes = sourceHashHolder != null && sourceHashHolder.getHashedSource() != null ? Arrays.asList(sourceHashHolder.getHashedSource().hashes()) : new ArrayList(0);
        return new IssueTrackingInput<TrackedIssue>(rIssues, baseHashes);
    }

    private boolean shouldCopyServerIssues(InputComponent component) {
        InputFile inputFile;
        return !this.mode.scanAllFiles() && component.isFile() && (inputFile = (InputFile)component).status() == InputFile.Status.SAME;
    }

    private void copyServerIssues(Collection<ServerIssueFromWs> serverIssues, List<TrackedIssue> trackedIssues, String componentKey) {
        for (ServerIssueFromWs serverIssue : serverIssues) {
            ScannerInput.ServerIssue unmatchedPreviousIssue = serverIssue.getDto();
            TrackedIssue unmatched = IssueTransformer.toTrackedIssue(unmatchedPreviousIssue, componentKey);
            ActiveRule activeRule = this.activeRules.find(unmatched.getRuleKey());
            unmatched.setNew(false);
            if (activeRule == null) {
                IssueTransformer.resolveRemove(unmatched);
            }
            trackedIssues.add(unmatched);
        }
    }

    @CheckForNull
    private SourceHashHolder loadSourceHashes(InputComponent component) {
        SourceHashHolder sourceHashHolder = null;
        if (component.isFile()) {
            DefaultInputModule module = (DefaultInputModule)this.componentTree.getParent(this.componentTree.getParent(component));
            DefaultInputFile file = (DefaultInputFile)component;
            sourceHashHolder = new SourceHashHolder(module, file, this.lastLineHashes);
        }
        return sourceHashHolder;
    }

    private Collection<ServerIssueFromWs> loadServerIssues(InputComponent component) {
        ArrayList<ServerIssueFromWs> serverIssues = new ArrayList<ServerIssueFromWs>();
        for (ScannerInput.ServerIssue previousIssue : this.serverIssueRepository.byComponent(component)) {
            serverIssues.add(new ServerIssueFromWs(previousIssue));
        }
        return serverIssues;
    }

    @VisibleForTesting
    protected void mergeMatched(Tracking<TrackedIssue, ServerIssueFromWs> result, Collection<TrackedIssue> mergeTo, Collection<TrackedIssue> rawIssues) {
        for (Map.Entry e : result.getMatchedRaws().entrySet()) {
            ScannerInput.ServerIssue dto = ((ServerIssueFromWs)e.getValue()).getDto();
            TrackedIssue tracked = (TrackedIssue)e.getKey();
            tracked.setKey(dto.getKey());
            tracked.setNew(false);
            tracked.setResolution(dto.hasResolution() ? dto.getResolution() : null);
            tracked.setStatus(dto.getStatus());
            tracked.setAssignee(dto.hasAssigneeLogin() ? dto.getAssigneeLogin() : null);
            tracked.setCreationDate(new Date(dto.getCreationDate()));
            if (dto.getManualSeverity()) {
                tracked.setSeverity(dto.getSeverity().name());
            }
            mergeTo.add(tracked);
        }
    }

    private void addUnmatchedFromServer(Iterable<ServerIssueFromWs> unmatchedIssues, Collection<TrackedIssue> mergeTo, String componentKey) {
        for (ServerIssueFromWs unmatchedIssue : unmatchedIssues) {
            ScannerInput.ServerIssue unmatchedPreviousIssue = unmatchedIssue.getDto();
            TrackedIssue unmatched = IssueTransformer.toTrackedIssue(unmatchedPreviousIssue, componentKey);
            this.updateUnmatchedIssue(unmatched);
            mergeTo.add(unmatched);
        }
    }

    private static void addUnmatchedFromReport(Iterable<TrackedIssue> rawIssues, Collection<TrackedIssue> trackedIssues, Date analysisDate) {
        for (TrackedIssue rawIssue : rawIssues) {
            rawIssue.setCreationDate(analysisDate);
            trackedIssues.add(rawIssue);
        }
    }

    private void addIssuesOnDeletedComponents(Collection<TrackedIssue> issues, String componentKey) {
        for (ScannerInput.ServerIssue previous : this.serverIssueRepository.issuesOnMissingComponents()) {
            TrackedIssue dead = IssueTransformer.toTrackedIssue(previous, componentKey);
            this.updateUnmatchedIssue(dead);
            issues.add(dead);
        }
    }

    private void updateUnmatchedIssue(TrackedIssue issue) {
        boolean isRemovedRule;
        ActiveRule activeRule = this.activeRules.find(issue.getRuleKey());
        issue.setNew(false);
        boolean bl = isRemovedRule = activeRule == null;
        if (isRemovedRule) {
            IssueTransformer.resolveRemove(issue);
        } else {
            IssueTransformer.close(issue);
        }
    }
}

