/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.scanner.scan.measure.MeasureCache;

public class DefaultFileLinesContext
implements FileLinesContext {
    private final SensorContext context;
    private final InputFile inputFile;
    private final MetricFinder metricFinder;
    private final MeasureCache measureCache;
    private final Map<String, Map<Integer, Object>> map = new HashMap<String, Map<Integer, Object>>();

    public DefaultFileLinesContext(SensorContext context, InputFile inputFile, MetricFinder metricFinder, MeasureCache measureCache) {
        this.context = context;
        this.inputFile = inputFile;
        this.metricFinder = metricFinder;
        this.measureCache = measureCache;
    }

    public void setIntValue(String metricKey, int line, int value) {
        Preconditions.checkNotNull((Object)metricKey);
        this.checkLineRange(line);
        this.setValue(metricKey, line, value);
    }

    private void checkLineRange(int line) {
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0, (String)"Line number should be positive for file %s.", (Object[])new Object[]{this.inputFile});
        Preconditions.checkArgument((line <= this.inputFile.lines() ? 1 : 0) != 0, (String)"Line %s is out of range for file %s. File has %s lines.", (Object[])new Object[]{line, this.inputFile, this.inputFile.lines()});
    }

    public Integer getIntValue(String metricKey, int line) {
        Preconditions.checkNotNull((Object)metricKey);
        this.checkLineRange(line);
        Map lines = this.map.computeIfAbsent(metricKey, k -> this.loadData((String)k, (KeyValueFormat.Converter<? extends Object>)KeyValueFormat.newIntegerConverter()));
        return (Integer)lines.get(line);
    }

    public void setStringValue(String metricKey, int line, String value) {
        Preconditions.checkNotNull((Object)metricKey);
        this.checkLineRange(line);
        Preconditions.checkNotNull((Object)value);
        this.setValue(metricKey, line, value);
    }

    public String getStringValue(String metricKey, int line) {
        Preconditions.checkNotNull((Object)metricKey);
        this.checkLineRange(line);
        Map lines = this.map.computeIfAbsent(metricKey, k -> this.loadData((String)k, (KeyValueFormat.Converter<? extends Object>)KeyValueFormat.newStringConverter()));
        return (String)lines.get(line);
    }

    private void setValue(String metricKey, int line, Object value) {
        this.map.computeIfAbsent(metricKey, k -> new HashMap()).put(line, value);
    }

    public void save() {
        for (Map.Entry<String, Map<Integer, Object>> entry : this.map.entrySet()) {
            String metricKey = entry.getKey();
            Map<Integer, Object> lines = entry.getValue();
            if (!DefaultFileLinesContext.shouldSave(lines)) continue;
            String data = KeyValueFormat.format(DefaultFileLinesContext.optimizeStorage(metricKey, lines));
            this.context.newMeasure().on((InputComponent)this.inputFile).forMetric(this.metricFinder.findByKey(metricKey)).withValue((Serializable)((Object)data)).save();
            entry.setValue((Map<Integer, Object>)ImmutableMap.copyOf(lines));
        }
    }

    private static Map<Integer, Object> optimizeStorage(String metricKey, Map<Integer, Object> lines) {
        if ("ncloc_data".equals(metricKey) || "comment_lines_data".equals(metricKey) || "executable_lines_data".equals(metricKey)) {
            return lines.entrySet().stream().filter(entry -> !entry.getValue().equals(0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return lines;
    }

    private Map<Integer, Object> loadData(String metricKey, KeyValueFormat.Converter<? extends Object> converter) {
        String data;
        DefaultMeasure<?> measure = this.measureCache.byMetric(this.inputFile.key(), metricKey);
        String string = data = measure != null ? (String)((Object)measure.value()) : null;
        if (data != null) {
            return ImmutableMap.copyOf((Map)KeyValueFormat.parse((String)data, (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter(), converter));
        }
        return ImmutableMap.of();
    }

    private static boolean shouldSave(Map<Integer, Object> lines) {
        return !(lines instanceof ImmutableMap);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("map", this.map).toString();
    }
}

