/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.internal.DefaultNewRule;
import org.sonar.api.utils.Preconditions;

public class DefaultNewRepository
implements RulesDefinition.NewRepository {
    private final RulesDefinition.Context context;
    private final String key;
    private final boolean isExternal;
    private final String language;
    private String name;
    private final Map<String, RulesDefinition.NewRule> newRules = new HashMap<String, RulesDefinition.NewRule>();

    public DefaultNewRepository(RulesDefinition.Context context, String key, String language, boolean isExternal) {
        this.context = context;
        this.key = key;
        this.name = key;
        this.language = language;
        this.isExternal = isExternal;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public String key() {
        return this.key;
    }

    public String language() {
        return this.language;
    }

    public Map<String, RulesDefinition.NewRule> newRules() {
        return this.newRules;
    }

    public String name() {
        return this.name;
    }

    @Override
    public DefaultNewRepository setName(@Nullable String s) {
        if (StringUtils.isNotEmpty(s)) {
            this.name = s;
        }
        return this;
    }

    @Override
    public RulesDefinition.NewRule createRule(String ruleKey) {
        Preconditions.checkArgument(!this.newRules.containsKey(ruleKey), "The rule '%s' of repository '%s' is declared several times", ruleKey, this.key);
        DefaultNewRule newRule = new DefaultNewRule(this.context.currentPluginKey(), this.key, ruleKey);
        this.newRules.put(ruleKey, newRule);
        return newRule;
    }

    @Override
    @CheckForNull
    public RulesDefinition.NewRule rule(String ruleKey) {
        return this.newRules.get(ruleKey);
    }

    @Override
    public Collection<RulesDefinition.NewRule> rules() {
        return this.newRules.values();
    }

    @Override
    public void done() {
        this.context.registerRepository(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NewRepository{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", language='").append(this.language).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

