/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;
import org.sonar.api.server.ServerSide;

@ServerSide
@ComputeEngineSide
@Beta
public class ResourceTypes {
    public static final Predicate<ResourceType> AVAILABLE_FOR_FILTERS = input -> input != null && input.getBooleanProperty("supportsMeasureFilters");
    private final Map<String, ResourceTypeTree> treeByQualifier;
    private final Map<String, ResourceType> typeByQualifier;
    private final Collection<ResourceType> orderedTypes;
    private final Collection<ResourceType> rootTypes;

    public ResourceTypes() {
        this(new ResourceTypeTree[0]);
    }

    public ResourceTypes(ResourceTypeTree[] trees) {
        Objects.requireNonNull(trees);
        LinkedHashMap<String, ResourceTypeTree> treeMap = new LinkedHashMap<String, ResourceTypeTree>();
        LinkedHashMap<String, ResourceType> typeMap = new LinkedHashMap<String, ResourceType>();
        LinkedHashSet<ResourceType> rootsSet = new LinkedHashSet<ResourceType>();
        for (ResourceTypeTree tree : trees) {
            rootsSet.add(tree.getRootType());
            for (ResourceType type : tree.getTypes()) {
                if (treeMap.containsKey(type.getQualifier())) {
                    throw new IllegalStateException("Qualifier " + type.getQualifier() + " is defined in several trees");
                }
                treeMap.put(type.getQualifier(), tree);
                typeMap.put(type.getQualifier(), type);
            }
        }
        this.treeByQualifier = Collections.unmodifiableMap(new LinkedHashMap(treeMap));
        this.typeByQualifier = Collections.unmodifiableMap(new LinkedHashMap(typeMap));
        this.rootTypes = Collections.unmodifiableList(new ArrayList(rootsSet));
        this.orderedTypes = Collections.unmodifiableSet(ResourceTypes.orderedTypes(typeMap));
    }

    private static Set<ResourceType> orderedTypes(Map<String, ResourceType> typeByQualifier) {
        LinkedHashMap<String, ResourceType> mutableTypesByQualifier = new LinkedHashMap<String, ResourceType>(typeByQualifier);
        ResourceType view = (ResourceType)mutableTypesByQualifier.remove("VW");
        ResourceType subView = (ResourceType)mutableTypesByQualifier.remove("SVW");
        ResourceType application = (ResourceType)mutableTypesByQualifier.remove("APP");
        return Stream.concat(Stream.of(view, subView, application), mutableTypesByQualifier.values().stream()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public ResourceType get(String qualifier) {
        ResourceType type = this.typeByQualifier.get(qualifier);
        return type != null ? type : ResourceType.builder(qualifier).build();
    }

    public Collection<ResourceType> getAll() {
        return this.typeByQualifier.values();
    }

    public Collection<ResourceType> getAllOrdered() {
        return this.orderedTypes;
    }

    public Collection<ResourceType> getRoots() {
        return this.rootTypes;
    }

    public Collection<ResourceType> getAll(Predicate<ResourceType> predicate) {
        return this.typeByQualifier.values().stream().filter(predicate).collect(Collectors.toList());
    }

    public Collection<ResourceType> getAllWithPropertyKey(String propertyKey) {
        return this.typeByQualifier.values().stream().filter(Objects::nonNull).filter(input -> input.hasProperty(propertyKey)).collect(Collectors.toList());
    }

    public Collection<ResourceType> getAllWithPropertyValue(String propertyKey, String propertyValue) {
        return this.typeByQualifier.values().stream().filter(Objects::nonNull).filter(input -> Objects.equals(propertyValue, input.getStringProperty(propertyKey))).collect(Collectors.toList());
    }

    public Collection<ResourceType> getAllWithPropertyValue(String propertyKey, boolean propertyValue) {
        return this.typeByQualifier.values().stream().filter(Objects::nonNull).filter(input -> input.getBooleanProperty(propertyKey) == propertyValue).collect(Collectors.toList());
    }

    public List<String> getChildrenQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getChildren(qualifier);
        }
        return Collections.emptyList();
    }

    public List<ResourceType> getChildren(String qualifier) {
        return this.getChildrenQualifiers(qualifier).stream().map(this.typeByQualifier::get).collect(Collectors.toList());
    }

    public List<String> getLeavesQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getLeaves();
        }
        return Collections.emptyList();
    }

    public ResourceTypeTree getTree(String qualifier) {
        return this.treeByQualifier.get(qualifier);
    }

    public ResourceType getRoot(String qualifier) {
        return this.getTree(qualifier).getRootType();
    }
}

