/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.server.ServerSide;

@ServerSide
@ComputeEngineSide
public class EmailSettings {
    public static final String SMTP_HOST = "email.smtp_host.secured";
    public static final String SMTP_HOST_DEFAULT = "";
    public static final String SMTP_PORT = "email.smtp_port.secured";
    public static final String SMTP_PORT_DEFAULT = "25";
    public static final String SMTP_SECURE_CONNECTION = "email.smtp_secure_connection.secured";
    public static final String SMTP_SECURE_CONNECTION_DEFAULT = "";
    public static final String SMTP_USERNAME = "email.smtp_username.secured";
    public static final String SMTP_USERNAME_DEFAULT = "";
    public static final String SMTP_PASSWORD = "email.smtp_password.secured";
    public static final String SMTP_PASSWORD_DEFAULT = "";
    public static final String FROM = "email.from";
    public static final String FROM_DEFAULT = "noreply@nowhere";
    public static final String FROM_NAME = "email.fromName";
    public static final String FROM_NAME_DEFAULT = "SonarQube";
    public static final String PREFIX = "email.prefix";
    public static final String PREFIX_DEFAULT = "[SONARQUBE]";
    private final Configuration config;

    public EmailSettings(Configuration config) {
        this.config = config;
    }

    public String getSmtpHost() {
        return this.get(SMTP_HOST, "");
    }

    public int getSmtpPort() {
        return Integer.parseInt(this.get(SMTP_PORT, SMTP_PORT_DEFAULT));
    }

    public String getSecureConnection() {
        return this.get(SMTP_SECURE_CONNECTION, "");
    }

    public String getSmtpUsername() {
        return this.get(SMTP_USERNAME, "");
    }

    public String getSmtpPassword() {
        return this.get(SMTP_PASSWORD, "");
    }

    public String getFrom() {
        return this.get(FROM, FROM_DEFAULT);
    }

    public String getFromName() {
        return this.get(FROM_NAME, FROM_NAME_DEFAULT);
    }

    public String getPrefix() {
        return this.get(PREFIX, PREFIX_DEFAULT);
    }

    public String getServerBaseURL() {
        return this.get("sonar.core.serverBaseURL", "http://localhost:9000");
    }

    private String get(String key, String defaultValue) {
        return this.config.get(key).orElse(defaultValue);
    }

    public static List<PropertyDefinition> definitions() {
        return Arrays.asList(PropertyDefinition.builder(SMTP_HOST).name("SMTP host").description("For example \"smtp.gmail.com\". Leave blank to disable email sending.").defaultValue("").category("general").subCategory("email").build(), PropertyDefinition.builder(SMTP_PORT).name("SMTP port").description("Port number to connect with SMTP server.").defaultValue(SMTP_PORT_DEFAULT).category("general").subCategory("email").type(PropertyType.INTEGER).build(), PropertyDefinition.builder(SMTP_SECURE_CONNECTION).name("Secure connection").description("Type of secure connection. Leave empty to not use secure connection.").defaultValue("").category("general").subCategory("email").type(PropertyType.SINGLE_SELECT_LIST).options("ssl", "starttls").build(), PropertyDefinition.builder(SMTP_USERNAME).name("SMTP username").description("Username to use with authenticated SMTP.").defaultValue("").category("general").subCategory("email").build(), PropertyDefinition.builder(SMTP_PASSWORD).name("SMTP password").description("Password to use with authenticated SMTP.").defaultValue("").type(PropertyType.PASSWORD).category("general").subCategory("email").build(), PropertyDefinition.builder(FROM).name("From address").description("Emails will come from this address. For example - \"noreply@sonarsource.com\". Note that server may ignore this setting.").defaultValue(FROM_DEFAULT).category("general").subCategory("email").build(), PropertyDefinition.builder(FROM_NAME).name("From name").description("Emails will come from this address name. For example - \"SonarQube\". Note that server may ignore this setting.").defaultValue(FROM_NAME_DEFAULT).category("general").subCategory("email").build(), PropertyDefinition.builder(PREFIX).name("Email prefix").description("Prefix will be prepended to all outgoing email subjects.").defaultValue(PREFIX_DEFAULT).category("general").subCategory("email").build());
    }
}

