/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.UpdateCenter;

public final class UpdateCenterSerializer {
    private UpdateCenterSerializer() {
    }

    private static void set(Properties props, String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            props.setProperty(key, value);
        }
    }

    private static void set(Properties props, String key, Collection values) {
        if (values != null && !values.isEmpty()) {
            props.setProperty(key, StringUtils.join(values, ","));
        }
    }

    private static void set(Properties props, Plugin plugin, String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            props.setProperty(plugin.getKey() + "." + key, value);
        }
    }

    private static void set(Properties props, Plugin plugin, String key, Collection values) {
        if (values != null && !values.isEmpty()) {
            props.setProperty(plugin.getKey() + "." + key, StringUtils.join(values, ","));
        }
    }

    public static Properties toProperties(UpdateCenter center) {
        Properties p = new Properties();
        UpdateCenterSerializer.set(p, "date", FormatUtils.toString(center.getDate(), true));
        UpdateCenterSerializer.set(p, "publicVersions", center.getSonar().getPublicVersions());
        if (!center.getSonar().getPrivateVersions().isEmpty()) {
            UpdateCenterSerializer.set(p, "privateVersions", center.getSonar().getPrivateVersions());
        }
        if (center.getSonar().getDevRelease() != null) {
            UpdateCenterSerializer.set(p, "devVersion", center.getSonar().getDevRelease().getVersion().toString());
        }
        UpdateCenterSerializer.set(p, "sonar.versions", center.getSonar().getVersions());
        if (center.getSonar().getLtsRelease() != null) {
            UpdateCenterSerializer.set(p, "ltsVersion", center.getSonar().getLtsRelease().getVersion().toString());
        }
        for (Release sonarRelease : center.getSonar().getAllReleases()) {
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".downloadUrl", sonarRelease.getDownloadUrl());
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".changelogUrl", sonarRelease.getChangelogUrl());
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".description", sonarRelease.getDescription());
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".date", FormatUtils.toString(sonarRelease.getDate(), false));
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".downloadUrl", sonarRelease.getDownloadUrl());
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".changelogUrl", sonarRelease.getChangelogUrl());
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".description", sonarRelease.getDescription());
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".date", FormatUtils.toString(sonarRelease.getDate(), false));
        }
        ArrayList pluginKeys = Lists.newArrayList();
        for (Plugin plugin : center.getUpdateCenterPluginReferential().getPlugins()) {
            UpdateCenterSerializer.addPlugin(plugin, pluginKeys, p);
        }
        UpdateCenterSerializer.set(p, "plugins", pluginKeys);
        return p;
    }

    private static void addPlugin(Plugin plugin, List<String> pluginKeys, Properties p) {
        pluginKeys.add(plugin.getKey());
        UpdateCenterSerializer.set(p, plugin, "name", plugin.getName());
        UpdateCenterSerializer.set(p, plugin, "description", plugin.getDescription());
        UpdateCenterSerializer.set(p, plugin, "category", plugin.getCategory());
        UpdateCenterSerializer.set(p, plugin, "homepageUrl", plugin.getHomepageUrl());
        UpdateCenterSerializer.set(p, plugin, "license", plugin.getLicense());
        UpdateCenterSerializer.set(p, plugin, "organization", plugin.getOrganization());
        UpdateCenterSerializer.set(p, plugin, "organizationUrl", plugin.getOrganizationUrl());
        UpdateCenterSerializer.set(p, plugin, "termsConditionsUrl", plugin.getTermsConditionsUrl());
        UpdateCenterSerializer.set(p, plugin, "issueTrackerUrl", plugin.getIssueTrackerUrl());
        UpdateCenterSerializer.set(p, plugin, "scm", plugin.getSourcesUrl());
        UpdateCenterSerializer.set(p, plugin, "developers", StringUtils.join(plugin.getDevelopers(), ","));
        for (Release release : plugin.getAllReleases()) {
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".sqVersions", StringUtils.join(release.getRequiredSonarVersions(), ","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".requiredSonarVersions", StringUtils.join(release.getRequiredSonarVersions(), ","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".downloadUrl", release.getDownloadUrl());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".changelogUrl", release.getChangelogUrl());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".description", release.getDescription());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".mavenGroupId", release.groupId());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".mavenArtifactId", release.artifactId());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".date", FormatUtils.toString(release.getDate(), false));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".requirePlugins", StringUtils.join((Object[])UpdateCenterSerializer.getRequiredList(release), ","));
        }
        UpdateCenterSerializer.set(p, plugin, "publicVersions", plugin.getPublicVersions());
        if (!plugin.getPrivateVersions().isEmpty()) {
            UpdateCenterSerializer.set(p, plugin, "privateVersions", plugin.getPrivateVersions());
        }
        if (!plugin.getArchivedVersions().isEmpty()) {
            UpdateCenterSerializer.set(p, plugin, "archivedVersions", plugin.getArchivedVersions());
        }
        if (plugin.getDevRelease() != null) {
            UpdateCenterSerializer.set(p, plugin, "devVersion", plugin.getDevRelease().getVersion().toString());
        }
        UpdateCenterSerializer.set(p, plugin, "versions", plugin.getVersions());
    }

    public static void toProperties(UpdateCenter sonar, File toFile) {
        FileOutputStream output = null;
        try {
            output = FileUtils.openOutputStream(toFile);
            UpdateCenterSerializer.toProperties(sonar).store(output, "Generated file");
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to store update center properties to: " + toFile.getAbsolutePath(), e);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
    }

    private static String[] getRequiredList(Release release) {
        ArrayList requiredStringList = Lists.newArrayList();
        for (Release requiredRelease : release.getOutgoingDependencies()) {
            requiredStringList.add(requiredRelease.getArtifact().getKey() + ":" + requiredRelease.getVersion().getName());
        }
        return requiredStringList.toArray(new String[0]);
    }
}

