/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.lifecycle.ReflectionLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.ComponentKeys;
import org.sonar.core.platform.ContainerPopulator;
import org.sonar.core.platform.PicoUtils;
import org.sonar.core.platform.PluginInfo;

@BatchSide
@ServerSide
public class ComponentContainer
implements ContainerPopulator.Container {
    private ComponentContainer parent;
    private final List<ComponentContainer> children = new ArrayList<ComponentContainer>();
    private MutablePicoContainer pico;
    private PropertyDefinitions propertyDefinitions;
    private ComponentKeys componentKeys;

    public ComponentContainer() {
        this(ComponentContainer.createPicoContainer());
    }

    protected ComponentContainer(MutablePicoContainer picoContainer) {
        this.parent = null;
        this.pico = picoContainer;
        this.componentKeys = new ComponentKeys();
        this.propertyDefinitions = new PropertyDefinitions(new Object[0]);
        this.addSingleton(this.propertyDefinitions);
        this.addSingleton(this);
    }

    protected ComponentContainer(ComponentContainer parent) {
        this.parent = parent;
        this.pico = parent.pico.makeChildContainer();
        this.parent.children.add(this);
        this.propertyDefinitions = parent.propertyDefinitions;
        this.componentKeys = new ComponentKeys();
        this.addSingleton(this);
    }

    protected void setParent(ComponentContainer parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        boolean threw = true;
        try {
            this.startComponents();
            threw = false;
        }
        finally {
            this.stopComponents(threw);
        }
    }

    public ComponentContainer startComponents() {
        try {
            this.doBeforeStart();
            this.pico.start();
            this.doAfterStart();
            return this;
        }
        catch (Exception e) {
            throw PicoUtils.propagate(e);
        }
    }

    protected void doBeforeStart() {
    }

    protected void doAfterStart() {
    }

    public ComponentContainer stopComponents() {
        return this.stopComponents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentContainer stopComponents(boolean swallowException) {
        try {
            this.pico.stop();
            this.pico.dispose();
        }
        catch (RuntimeException e) {
            if (!swallowException) {
                throw PicoUtils.propagate(e);
            }
        }
        finally {
            this.removeChildren();
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
        }
        return this;
    }

    @Override
    public ComponentContainer add(Object ... objects) {
        for (Object object : objects) {
            if (object instanceof ComponentAdapter) {
                this.addPicoAdapter((ComponentAdapter)object);
                continue;
            }
            if (object instanceof Iterable) {
                this.add(Iterables.toArray((Iterable)((Iterable)object), Object.class));
                continue;
            }
            this.addSingleton(object);
        }
        return this;
    }

    public void addIfMissing(Object object, Class<?> objectType) {
        if (this.getComponentByType(objectType) == null) {
            this.add(object);
        }
    }

    @Override
    public ComponentContainer addSingletons(Iterable<?> components) {
        for (Object component : components) {
            this.addSingleton(component);
        }
        return this;
    }

    public ComponentContainer addSingleton(Object component) {
        return this.addComponent(component, true);
    }

    public ComponentContainer addComponent(Object component, boolean singleton) {
        Object key = this.componentKeys.of(component);
        if (component instanceof ComponentAdapter) {
            this.pico.addAdapter((ComponentAdapter)component);
        } else {
            try {
                this.pico.as(singleton ? Characteristics.CACHE : Characteristics.NO_CACHE).addComponent(key, component, new Parameter[0]);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to register component " + this.getName(component), t);
            }
            this.declareExtension(null, component);
        }
        return this;
    }

    public ComponentContainer addExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        Object key = this.componentKeys.of(extension);
        try {
            this.pico.as(Characteristics.CACHE).addComponent(key, extension, new Parameter[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to register extension " + this.getName(extension), t);
        }
        this.declareExtension(pluginInfo, extension);
        return this;
    }

    private String getName(Object extension) {
        if (extension instanceof Class) {
            return ((Class)extension).getName();
        }
        return this.getName(extension.getClass());
    }

    public void declareExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        this.propertyDefinitions.addComponent(extension, pluginInfo != null ? pluginInfo.getName() : "");
    }

    public ComponentContainer addPicoAdapter(ComponentAdapter<?> adapter) {
        this.pico.addAdapter(adapter);
        return this;
    }

    @Override
    public <T> T getComponentByType(Class<T> type) {
        return this.pico.getComponent(type);
    }

    public Object getComponentByKey(Object key) {
        return this.pico.getComponent(key);
    }

    public <T> List<T> getComponentsByType(Class<T> tClass) {
        return this.pico.getComponents(tClass);
    }

    public ComponentContainer removeChild(ComponentContainer childToBeRemoved) {
        Objects.requireNonNull(childToBeRemoved);
        Iterator<ComponentContainer> childrenIterator = this.children.iterator();
        while (childrenIterator.hasNext()) {
            ComponentContainer child = childrenIterator.next();
            if (child != childToBeRemoved) continue;
            if (!this.pico.removeChildContainer(child.pico)) break;
            childrenIterator.remove();
            break;
        }
        return this;
    }

    private ComponentContainer removeChildren() {
        Iterator<ComponentContainer> childrenIterator = this.children.iterator();
        while (childrenIterator.hasNext()) {
            ComponentContainer child = childrenIterator.next();
            if (!this.pico.removeChildContainer(child.pico)) continue;
            childrenIterator.remove();
        }
        return this;
    }

    public ComponentContainer createChild() {
        return new ComponentContainer(this);
    }

    public static MutablePicoContainer createPicoContainer() {
        ReflectionLifecycleStrategy lifecycleStrategy = new ReflectionLifecycleStrategy(new NullComponentMonitor(), "start", "stop", "close"){

            @Override
            public void start(Object component) {
                Profiler profiler = Profiler.createIfTrace(Loggers.get(ComponentContainer.class));
                profiler.start();
                super.start(component);
                profiler.stopTrace(component.getClass().getCanonicalName() + " started");
            }
        };
        return new ExtendedDefaultPicoContainer((ComponentFactory)new OptInCaching(), (LifecycleStrategy)lifecycleStrategy, null);
    }

    public ComponentContainer getParent() {
        return this.parent;
    }

    public List<ComponentContainer> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public MutablePicoContainer getPicoContainer() {
        return this.pico;
    }

    public int size() {
        return this.pico.getComponentAdapters().size();
    }

    private static final class ExtendedDefaultPicoContainer
    extends DefaultPicoContainer {
        private ExtendedDefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
            super(componentFactory, lifecycleStrategy, parent);
        }

        private ExtendedDefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent, ComponentMonitor componentMonitor) {
            super(componentFactory, lifecycleStrategy, parent, componentMonitor);
        }

        @Override
        public Object getComponent(Object componentKeyOrType, Class<? extends Annotation> annotation) {
            try {
                return super.getComponent(componentKeyOrType, annotation);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to load component " + componentKeyOrType, t);
            }
        }

        @Override
        public MutablePicoContainer makeChildContainer() {
            ExtendedDefaultPicoContainer pc = new ExtendedDefaultPicoContainer(this.componentFactory, this.lifecycleStrategy, (PicoContainer)this, this.componentMonitor);
            this.addChildContainer(pc);
            return pc;
        }
    }
}

