/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.workflow;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.issue.Issue;
import org.sonar.core.issue.workflow.Transition;

public class State {
    private final String key;
    private final Transition[] outTransitions;

    public State(String key, Transition[] outTransitions) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"State key must be set");
        Preconditions.checkArgument((boolean)StringUtils.isAllUpperCase(key), (Object)"State key must be upper-case");
        State.checkDuplications(outTransitions, key);
        this.key = key;
        this.outTransitions = outTransitions;
    }

    private static void checkDuplications(Transition[] transitions, String stateKey) {
        HashSet keys = Sets.newHashSet();
        for (Transition transition : transitions) {
            if (keys.contains(transition.key())) {
                throw new IllegalArgumentException("Transition '" + transition.key() + "' is declared several times from the originating state '" + stateKey + "'");
            }
            keys.add(transition.key());
        }
    }

    public List<Transition> outManualTransitions(Issue issue) {
        ArrayList result = Lists.newArrayList();
        for (Transition transition : this.outTransitions) {
            if (transition.automatic() || !transition.supports(issue)) continue;
            result.add(transition);
        }
        return result;
    }

    @CheckForNull
    public Transition outAutomaticTransition(Issue issue) {
        Transition result = null;
        for (Transition transition : this.outTransitions) {
            if (!transition.automatic() || !transition.supports(issue)) continue;
            if (result == null) {
                result = transition;
                continue;
            }
            throw new IllegalStateException("Several automatic transitions are available for issue: " + issue);
        }
        return result;
    }

    Transition transition(String transitionKey) {
        for (Transition transition : this.outTransitions) {
            if (!transitionKey.equals(transition.key())) continue;
            return transition;
        }
        throw new IllegalStateException("Transition from state " + this.key + " does not exist: " + transitionKey);
    }
}

