/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.SonarException;

public final class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final ThreadSafeDateFormat THREAD_SAFE_DATE_FORMAT = new ThreadSafeDateFormat("yyyy-MM-dd");
    private static final ThreadSafeDateFormat THREAD_SAFE_DATETIME_FORMAT = new ThreadSafeDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    private DateUtils() {
    }

    public static String formatDate(Date d) {
        return THREAD_SAFE_DATE_FORMAT.format(d);
    }

    public static String formatDateTime(Date d) {
        return THREAD_SAFE_DATETIME_FORMAT.format(d);
    }

    public static String formatDateTime(long ms) {
        return THREAD_SAFE_DATETIME_FORMAT.format(new Date(ms));
    }

    public static String formatDateTimeNullSafe(@Nullable Date date) {
        return date == null ? "" : THREAD_SAFE_DATETIME_FORMAT.format(date);
    }

    @CheckForNull
    public static Date longToDate(@Nullable Long time) {
        return time == null ? null : new Date(time);
    }

    @CheckForNull
    public static Long dateToLong(@Nullable Date date) {
        return date == null ? null : Long.valueOf(date.getTime());
    }

    public static Date parseDate(String s) {
        ParsePosition pos = new ParsePosition(0);
        Date result = THREAD_SAFE_DATE_FORMAT.parse(s, pos);
        if (pos.getIndex() != s.length()) {
            throw new SonarException("The date '" + s + "' does not respect format '" + DATE_FORMAT + "'");
        }
        return result;
    }

    @CheckForNull
    public static Date parseDateQuietly(@Nullable String s) {
        Date date = null;
        if (s != null) {
            try {
                date = DateUtils.parseDate(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date parseDateTime(String s) {
        ParsePosition pos = new ParsePosition(0);
        Date result = THREAD_SAFE_DATETIME_FORMAT.parse(s, pos);
        if (pos.getIndex() != s.length()) {
            throw new SonarException("The date '" + s + "' does not respect format '" + DATETIME_FORMAT + "'");
        }
        return result;
    }

    @CheckForNull
    public static Date parseDateTimeQuietly(@Nullable String s) {
        Date datetime = null;
        if (s != null) {
            try {
                datetime = DateUtils.parseDateTime(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return datetime;
    }

    public static Date addDays(Date date, int numberOfDays) {
        return org.sonar.api.internal.apachecommons.lang.time.DateUtils.addDays(date, numberOfDays);
    }

    static class ThreadSafeDateFormat
    extends DateFormat {
        private final String format;
        private final ThreadLocal<Reference<DateFormat>> cache = new ThreadLocal<Reference<DateFormat>>(){

            @Override
            public Reference<DateFormat> get() {
                SoftReference<SimpleDateFormat> softRef = (SoftReference<SimpleDateFormat>)super.get();
                if (softRef == null || ((Reference)softRef).get() == null) {
                    SimpleDateFormat sdf = new SimpleDateFormat(ThreadSafeDateFormat.this.format);
                    sdf.setLenient(false);
                    softRef = new SoftReference<SimpleDateFormat>(sdf);
                    super.set(softRef);
                }
                return softRef;
            }
        };

        ThreadSafeDateFormat(String format) {
            this.format = format;
        }

        private DateFormat getDateFormat() {
            return this.cache.get().get();
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.getDateFormat().format(date, toAppendTo, fieldPosition);
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            return this.getDateFormat().parse(source, pos);
        }

        private void readObject(ObjectInputStream ois) throws NotSerializableException {
            throw new NotSerializableException();
        }

        private void writeObject(ObjectOutputStream ois) throws NotSerializableException {
            throw new NotSerializableException();
        }
    }
}

