/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.check.Cardinality;

@ServerSide
public class RulesDefinitionXmlLoader {
    public void load(RulesDefinition.NewRepository repo, InputStream input, String encoding) {
        this.load(repo, input, Charset.forName(encoding));
    }

    public void load(RulesDefinition.NewRepository repo, InputStream input, Charset charset) {
        try (InputStreamReader reader = new InputStreamReader(input, charset);){
            this.load(repo, reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while reading XML rules definition for repository " + repo.key(), e);
        }
    }

    public void load(RulesDefinition.NewRepository repo, Reader reader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            SMInputCursor rulesC = rootC.childElementCursor("rule");
            while (rulesC.getNext() != null) {
                this.processRule(repo, rulesC);
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private void processRule(RulesDefinition.NewRepository repo, SMInputCursor ruleC) throws XMLStreamException {
        String priorityAttribute;
        String key = null;
        String name = null;
        String description = null;
        String descriptionFormat = DescriptionFormat.HTML.name();
        String internalKey = null;
        String severity = Severity.defaultSeverity();
        RuleStatus status = RuleStatus.defaultStatus();
        boolean template = false;
        String effortToFixDescription = null;
        String debtSubCharacteristic = null;
        String debtRemediationFunction = null;
        String debtRemediationFunctionOffset = null;
        String debtRemediationFunctionCoeff = null;
        ArrayList<ParamStruct> params = new ArrayList<ParamStruct>();
        ArrayList<String> tags = new ArrayList<String>();
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank(keyAttribute)) {
            key = StringUtils.trim(keyAttribute);
        }
        if (StringUtils.isNotBlank(priorityAttribute = ruleC.getAttrValue("priority"))) {
            severity = StringUtils.trim(priorityAttribute);
        }
        SMInputCursor cursor = ruleC.childElementCursor();
        while (cursor.getNext() != null) {
            String nodeName = cursor.getLocalName();
            if (StringUtils.equalsIgnoreCase("name", nodeName)) {
                name = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("description", nodeName)) {
                description = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("descriptionFormat", nodeName)) {
                descriptionFormat = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("key", nodeName)) {
                key = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("configKey", nodeName)) {
                internalKey = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("internalKey", nodeName)) {
                internalKey = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("priority", nodeName)) {
                severity = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("severity", nodeName)) {
                severity = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("cardinality", nodeName)) {
                template = Cardinality.MULTIPLE == Cardinality.valueOf(RulesDefinitionXmlLoader.nodeValue(cursor));
                continue;
            }
            if (StringUtils.equalsIgnoreCase("effortToFixDescription", nodeName)) {
                effortToFixDescription = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("debtRemediationFunction", nodeName)) {
                debtRemediationFunction = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("debtRemediationFunctionOffset", nodeName)) {
                debtRemediationFunctionOffset = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("debtRemediationFunctionCoefficient", nodeName)) {
                debtRemediationFunctionCoeff = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("debtSubCharacteristic", nodeName)) {
                debtSubCharacteristic = RulesDefinitionXmlLoader.nodeValue(cursor);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("status", nodeName)) {
                String s = RulesDefinitionXmlLoader.nodeValue(cursor);
                if (s == null) continue;
                status = RuleStatus.valueOf(s);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("param", nodeName)) {
                params.add(this.processParameter(cursor));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase("tag", nodeName)) continue;
            tags.add(RulesDefinitionXmlLoader.nodeValue(cursor));
        }
        try {
            RulesDefinition.NewRule rule = repo.createRule(key).setSeverity(severity).setName(name).setInternalKey(internalKey).setTags(tags.toArray(new String[tags.size()])).setTemplate(template).setStatus(status).setEffortToFixDescription(effortToFixDescription).setDebtSubCharacteristic(debtSubCharacteristic);
            RulesDefinitionXmlLoader.fillDescription(rule, descriptionFormat, description);
            RulesDefinitionXmlLoader.fillRemediationFunction(rule, debtRemediationFunction, debtRemediationFunctionOffset, debtRemediationFunctionCoeff);
            RulesDefinitionXmlLoader.fillParams(rule, params);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Fail to load the rule with key [%s:%s]", repo.key(), key), e);
        }
    }

    private static void fillDescription(RulesDefinition.NewRule rule, String descriptionFormat, @Nullable String description) {
        if (StringUtils.isNotBlank(description)) {
            switch (DescriptionFormat.valueOf(descriptionFormat)) {
                case HTML: {
                    rule.setHtmlDescription(description);
                    break;
                }
                case MARKDOWN: {
                    rule.setMarkdownDescription(description);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Value of descriptionFormat is not supported: " + descriptionFormat);
                }
            }
        }
    }

    private static void fillRemediationFunction(RulesDefinition.NewRule rule, @Nullable String debtRemediationFunction, @Nullable String functionOffset, @Nullable String functionCoeff) {
        if (StringUtils.isNotBlank(debtRemediationFunction)) {
            DebtRemediationFunction.Type functionType = DebtRemediationFunction.Type.valueOf(debtRemediationFunction);
            rule.setDebtRemediationFunction(rule.debtRemediationFunctions().create(functionType, functionCoeff, functionOffset));
        }
    }

    private static void fillParams(RulesDefinition.NewRule rule, List<ParamStruct> params) {
        for (ParamStruct param : params) {
            rule.createParam(param.key).setDefaultValue(param.defaultValue).setType(param.type).setDescription(param.description);
        }
    }

    private static String nodeValue(SMInputCursor cursor) throws XMLStreamException {
        return StringUtils.trim(cursor.collectDescendantText(false));
    }

    private ParamStruct processParameter(SMInputCursor ruleC) throws XMLStreamException {
        String typeAttribute;
        ParamStruct param = new ParamStruct();
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank(keyAttribute)) {
            param.key = StringUtils.trim(keyAttribute);
        }
        if (StringUtils.isNotBlank(typeAttribute = ruleC.getAttrValue("type"))) {
            param.type = RuleParamType.parse(typeAttribute);
        }
        SMInputCursor paramC = ruleC.childElementCursor();
        while (paramC.getNext() != null) {
            String propNodeName = paramC.getLocalName();
            String propText = RulesDefinitionXmlLoader.nodeValue(paramC);
            if (StringUtils.equalsIgnoreCase("key", propNodeName)) {
                param.key = propText;
                continue;
            }
            if (StringUtils.equalsIgnoreCase("description", propNodeName)) {
                param.description = propText;
                continue;
            }
            if (StringUtils.equalsIgnoreCase("type", propNodeName)) {
                param.type = RuleParamType.parse(propText);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase("defaultValue", propNodeName)) continue;
            param.defaultValue = propText;
        }
        return param;
    }

    private static class ParamStruct {
        String key;
        String description;
        String defaultValue;
        RuleParamType type = RuleParamType.STRING;

        private ParamStruct() {
        }
    }

    private static enum DescriptionFormat {
        HTML,
        MARKDOWN;

    }
}

