/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.utils.PathUtils;

public class DefaultInputFile
extends DefaultInputComponent
implements InputFile,
org.sonar.api.resources.InputFile {
    private final String relativePath;
    private final String moduleKey;
    private Path moduleBaseDir;
    private String language;
    private InputFile.Type type = InputFile.Type.MAIN;
    private InputFile.Status status;
    private int lines = -1;
    private Charset charset;
    private int lastValidOffset = -1;
    private String hash;
    private int nonBlankLines;
    private int[] originalLineOffsets;

    public DefaultInputFile(String moduleKey, String relativePath) {
        this.moduleKey = moduleKey;
        this.relativePath = PathUtils.sanitize(relativePath);
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public String absolutePath() {
        return PathUtils.sanitize(this.path().toString());
    }

    @Override
    public File file() {
        return this.path().toFile();
    }

    @Override
    public Path path() {
        if (this.moduleBaseDir == null) {
            throw new IllegalStateException("Can not return the java.nio.file.Path because module baseDir is not set (see method setModuleBaseDir(java.io.File))");
        }
        return this.moduleBaseDir.resolve(this.relativePath);
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    @Override
    public InputFile.Type type() {
        return this.type;
    }

    @Override
    public InputFile.Status status() {
        return this.status;
    }

    @Override
    public int lines() {
        return this.lines;
    }

    @Override
    public boolean isEmpty() {
        return this.lastValidOffset == 0;
    }

    @Override
    public String key() {
        return this.moduleKey + ":" + this.relativePath;
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public Charset charset() {
        return this.charset;
    }

    public DefaultInputFile setModuleBaseDir(Path moduleBaseDir) {
        this.moduleBaseDir = moduleBaseDir.normalize();
        return this;
    }

    public DefaultInputFile setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    public DefaultInputFile setType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public DefaultInputFile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public int lastValidOffset() {
        Preconditions.checkState(this.lastValidOffset >= 0, "InputFile is not properly initialized. Please set 'lastValidOffset' property.");
        return this.lastValidOffset;
    }

    public DefaultInputFile setLastValidOffset(int lastValidOffset) {
        this.lastValidOffset = lastValidOffset;
        return this;
    }

    public String hash() {
        return this.hash;
    }

    public int nonBlankLines() {
        return this.nonBlankLines;
    }

    public int[] originalLineOffsets() {
        Preconditions.checkState(this.originalLineOffsets != null, "InputFile is not properly initialized. Please set 'originalLineOffsets' property.");
        Preconditions.checkState(this.originalLineOffsets.length == this.lines, "InputFile is not properly initialized. 'originalLineOffsets' property length should be equal to 'lines'");
        return this.originalLineOffsets;
    }

    public DefaultInputFile setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public DefaultInputFile setNonBlankLines(int nonBlankLines) {
        this.nonBlankLines = nonBlankLines;
        return this;
    }

    public DefaultInputFile setOriginalLineOffsets(int[] originalLineOffsets) {
        this.originalLineOffsets = originalLineOffsets;
        return this;
    }

    @Override
    public TextPointer newPointer(int line, int lineOffset) {
        DefaultTextPointer textPointer = new DefaultTextPointer(line, lineOffset);
        this.checkValid(textPointer, "pointer");
        return textPointer;
    }

    private void checkValid(TextPointer pointer, String owner) {
        Preconditions.checkArgument(pointer.line() >= 1, "%s is not a valid line for a file", pointer.line());
        Preconditions.checkArgument(pointer.line() <= this.lines, "%s is not a valid line for %s. File %s has %s line(s)", pointer.line(), owner, this, this.lines);
        Preconditions.checkArgument(pointer.lineOffset() >= 0, "%s is not a valid line offset for a file", pointer.lineOffset());
        int lineLength = this.lineLength(pointer.line());
        Preconditions.checkArgument(pointer.lineOffset() <= lineLength, "%s is not a valid line offset for %s. File %s has %s character(s) at line %s", pointer.lineOffset(), owner, this, lineLength, pointer.line());
    }

    private int lineLength(int line) {
        return this.lastValidGlobalOffsetForLine(line) - this.originalLineOffsets()[line - 1];
    }

    private int lastValidGlobalOffsetForLine(int line) {
        return line < this.lines ? this.originalLineOffsets()[line] - 1 : this.lastValidOffset();
    }

    @Override
    public TextRange newRange(TextPointer start, TextPointer end) {
        this.checkValid(start, "start pointer");
        this.checkValid(end, "end pointer");
        return DefaultInputFile.newRangeValidPointers(start, end);
    }

    @Override
    public TextRange newRange(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        return DefaultInputFile.newRangeValidPointers(this.newPointer(startLine, startLineOffset), this.newPointer(endLine, endLineOffset));
    }

    @Override
    public TextRange selectLine(int line) {
        TextPointer startPointer = this.newPointer(line, 0);
        TextPointer endPointer = this.newPointer(line, this.lineLength(line));
        return DefaultInputFile.newRangeValidPointers(startPointer, endPointer);
    }

    public void validate(TextRange range) {
        this.checkValid(range.start(), "start pointer");
        this.checkValid(range.end(), "end pointer");
    }

    private static TextRange newRangeValidPointers(TextPointer start, TextPointer end) {
        Preconditions.checkArgument(start.compareTo(end) <= 0, "Start pointer %s should be before end pointer %s", start, end);
        return new DefaultTextRange(start, end);
    }

    public TextRange newRange(int startOffset, int endOffset) {
        return DefaultInputFile.newRangeValidPointers(this.newPointer(startOffset), this.newPointer(endOffset));
    }

    public TextPointer newPointer(int globalOffset) {
        Preconditions.checkArgument(globalOffset >= 0, "%s is not a valid offset for a file", globalOffset);
        Preconditions.checkArgument(globalOffset <= this.lastValidOffset(), "%s is not a valid offset for file %s. Max offset is %s", globalOffset, this, this.lastValidOffset());
        int line = this.findLine(globalOffset);
        int startLineOffset = this.originalLineOffsets()[line - 1];
        return new DefaultTextPointer(line, globalOffset - startLineOffset);
    }

    private int findLine(int globalOffset) {
        return Math.abs(Arrays.binarySearch(this.originalLineOffsets(), globalOffset) + 1);
    }

    public DefaultInputFile initMetadata(FileMetadata.Metadata metadata) {
        this.setLines(metadata.lines);
        this.setLastValidOffset(metadata.lastValidOffset);
        this.setNonBlankLines(metadata.nonBlankLines);
        this.setHash(metadata.hash);
        this.setOriginalLineOffsets(metadata.originalLineOffsets);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInputFile)) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)o;
        return this.moduleKey.equals(that.moduleKey) && this.relativePath.equals(that.relativePath);
    }

    @Override
    public int hashCode() {
        return this.moduleKey.hashCode() + this.relativePath.hashCode() * 13;
    }

    @Override
    public String toString() {
        return "[moduleKey=" + this.moduleKey + ", relative=" + this.relativePath + ", basedir=" + this.moduleBaseDir + "]";
    }

    @Override
    public File getFileBaseDir() {
        return this.moduleBaseDir.toFile();
    }

    @Override
    public File getFile() {
        return this.file();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath();
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.file()));
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

