/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.runner.cache.Logger;
import org.sonar.runner.cache.PersistentCache;
import org.sonar.runner.commonsio.FileUtils;
import org.sonar.runner.kevinsawicki.HttpRequest;

class ServerConnection {
    private static final String SONAR_SERVER_CAN_NOT_BE_REACHED = "SonarQube server ''{0}'' can not be reached";
    private static final String STATUS_RETURNED_BY_URL_IS_INVALID = "Status returned by url : ''{0}'' is invalid : {1}";
    static final int CONNECT_TIMEOUT_MILLISECONDS = 5000;
    static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    private final String serverUrl;
    private final String userAgent;
    private final PersistentCache wsCache;
    private final boolean preferCache;
    private final Logger logger;
    private final boolean isCacheEnabled;

    private ServerConnection(String serverUrl, String app, String appVersion, boolean preferCache, boolean cacheEnabled, PersistentCache cache, Logger logger) {
        this.isCacheEnabled = cacheEnabled;
        this.logger = logger;
        this.serverUrl = ServerConnection.removeEndSlash(serverUrl);
        this.userAgent = app + "/" + appVersion;
        this.wsCache = cache;
        this.preferCache = preferCache;
    }

    private static String removeEndSlash(String url) {
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    static ServerConnection create(Properties properties, PersistentCache cache, Logger logger, boolean preferCache) {
        String serverUrl = properties.getProperty("sonar.host.url");
        String app = properties.getProperty("sonarRunner.app");
        String appVersion = properties.getProperty("sonarRunner.appVersion");
        boolean enableCache = ServerConnection.isCacheEnabled(properties);
        return new ServerConnection(serverUrl, app, appVersion, preferCache, enableCache, cache, logger);
    }

    private static boolean isCacheEnabled(Properties properties) {
        String analysisMode = properties.getProperty("sonar.analysis.mode");
        return "issues".equalsIgnoreCase(analysisMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadString(String url, boolean saveCache) throws HttpRequest.HttpRequestException, IOException {
        this.logger.debug("Download: " + url);
        HttpRequest httpRequest = null;
        try {
            httpRequest = this.newHttpRequest(new URL(url));
            String charset = ServerConnection.getCharsetFromContentType(httpRequest.contentType());
            if (charset == null || "".equals(charset)) {
                charset = "UTF-8";
            }
            if (!httpRequest.ok()) {
                throw new IOException(MessageFormat.format(STATUS_RETURNED_BY_URL_IS_INVALID, url, httpRequest.code()));
            }
            byte[] body = httpRequest.bytes();
            if (saveCache) {
                try {
                    this.wsCache.put(url, body);
                }
                catch (IOException e) {
                    this.logger.warn("Failed to cache WS call: " + e.getMessage());
                }
            }
            String string = new String(body, charset);
            return string;
        }
        finally {
            if (httpRequest != null) {
                httpRequest.disconnect();
            }
        }
    }

    void download(String path, File toFile) {
        String fullUrl = this.serverUrl + path;
        try {
            this.logger.debug("Download " + fullUrl + " to " + toFile.getAbsolutePath());
            HttpRequest httpRequest = this.newHttpRequest(new URL(fullUrl));
            if (!httpRequest.ok()) {
                throw new IOException(MessageFormat.format(STATUS_RETURNED_BY_URL_IS_INVALID, fullUrl, httpRequest.code()));
            }
            httpRequest.receive(toFile);
        }
        catch (Exception e) {
            if (ServerConnection.isCausedByConnection(e)) {
                this.logger.error(MessageFormat.format(SONAR_SERVER_CAN_NOT_BE_REACHED, this.serverUrl));
            }
            FileUtils.deleteQuietly(toFile);
            throw new IllegalStateException("Fail to download: " + fullUrl, e);
        }
    }

    String loadString(String path) throws IOException {
        String fullUrl = this.serverUrl + path;
        if (this.isCacheEnabled && this.preferCache) {
            return this.tryCacheFirst(fullUrl);
        }
        return this.tryServerFirst(fullUrl, this.isCacheEnabled);
    }

    private String tryCacheFirst(String fullUrl) throws IOException {
        String cached = this.getFromCache(fullUrl);
        if (cached != null) {
            return cached;
        }
        try {
            return this.downloadString(fullUrl, this.preferCache);
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Data is not cached and SonarQube server ''{0}'' can not be reached", this.serverUrl));
            throw e;
        }
    }

    private String tryServerFirst(String fullUrl, boolean cacheEnabled) throws IOException {
        try {
            return this.downloadString(fullUrl, cacheEnabled);
        }
        catch (HttpRequest.HttpRequestException e) {
            if (cacheEnabled && ServerConnection.isCausedByConnection(e)) {
                this.logger.info(MessageFormat.format("SonarQube server ''{0}'' can not be reached, trying cache", this.serverUrl));
                String cached = this.getFromCache(fullUrl);
                if (cached != null) {
                    return cached;
                }
                this.logger.error(MessageFormat.format("SonarQube server ''{0}'' can not be reached and data is not cached", this.serverUrl));
                throw e;
            }
            this.logger.error(MessageFormat.format(SONAR_SERVER_CAN_NOT_BE_REACHED, this.serverUrl));
            throw e;
        }
    }

    private static boolean isCausedByConnection(Exception e) {
        return e.getCause() instanceof ConnectException || e.getCause() instanceof UnknownHostException || e.getCause() instanceof SocketTimeoutException;
    }

    private String getFromCache(String fullUrl) {
        try {
            return this.wsCache.getString(fullUrl);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to access cache", e);
        }
    }

    private HttpRequest newHttpRequest(URL url) {
        HttpRequest request = HttpRequest.get(url);
        request.trustAllCerts().trustAllHosts();
        request.acceptGzipEncoding().uncompress(true);
        request.connectTimeout(5000).readTimeout(60000);
        request.userAgent(this.userAgent);
        return request;
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }
}

