/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.maven.ExtensionsFactory;
import org.sonarsource.scanner.maven.bootstrap.ExceptionHandling;
import org.sonarsource.scanner.maven.bootstrap.MavenProjectConverter;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;

public class ScannerBootstrapper {
    private final Log log;
    private final MavenSession session;
    private final EmbeddedScanner scanner;
    private final MavenProjectConverter mavenProjectConverter;
    private final ExtensionsFactory extensionsFactory;
    private String serverVersion;
    private PropertyDecryptor propertyDecryptor;

    public ScannerBootstrapper(Log log, MavenSession session, EmbeddedScanner scanner, MavenProjectConverter mavenProjectConverter, ExtensionsFactory extensionsFactory, PropertyDecryptor propertyDecryptor) {
        this.log = log;
        this.session = session;
        this.scanner = scanner;
        this.mavenProjectConverter = mavenProjectConverter;
        this.extensionsFactory = extensionsFactory;
        this.propertyDecryptor = propertyDecryptor;
    }

    public void execute() throws IOException, MojoExecutionException {
        try {
            this.applyMasks();
            this.scanner.start();
            this.serverVersion = this.scanner.serverVersion();
            this.checkSQVersion();
            if (this.isVersionPriorTo5Dot2()) {
                if (this.supportsNewDependencyProperty()) {
                    this.scanner.addExtensions(this.extensionsFactory.createExtensionsWithDependencyProperty().toArray());
                } else {
                    this.scanner.addExtensions(this.extensionsFactory.createExtensions().toArray());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.scanner.setGlobalProperty("sonar.verbose", "true");
            }
            this.scanner.runAnalysis(this.collectProperties());
            this.scanner.stop();
        }
        catch (Exception e) {
            throw ExceptionHandling.handle(e, this.log);
        }
    }

    private void applyMasks() {
        this.scanner.mask("org.slf4j.LoggerFactory");
        this.scanner.unmask("org.slf4j.Logger");
        this.scanner.unmask("org.slf4j.ILoggerFactory");
        this.scanner.unmask("org.slf4j.Marker");
        this.scanner.mask("org.slf4j.");
        this.scanner.mask("ch.qos.logback.");
        this.scanner.mask("org.sonar.");
        this.scanner.mask("com.google.common");
        this.scanner.unmask("");
    }

    private Properties collectProperties() throws MojoExecutionException {
        List sortedProjects = this.session.getProjects();
        MavenProject topLevelProject = null;
        for (MavenProject project : sortedProjects) {
            if (!project.isExecutionRoot()) continue;
            topLevelProject = project;
            break;
        }
        if (topLevelProject == null) {
            throw new IllegalStateException("Maven session does not declare a top level project");
        }
        Properties props = this.mavenProjectConverter.configure(sortedProjects, topLevelProject, this.session.getUserProperties());
        props.putAll((Map<?, ?>)this.propertyDecryptor.decryptProperties(props));
        return props;
    }

    private void checkSQVersion() {
        if (this.serverVersion != null) {
            this.log.info((CharSequence)("SonarQube version: " + this.serverVersion));
        }
        if (this.isVersionPriorTo4Dot5()) {
            this.log.warn((CharSequence)"With SonarQube prior to 4.5, it is recommended to use maven-sonar-plugin 2.6");
        }
    }

    boolean isVersionPriorTo4Dot5() {
        if (this.serverVersion == null) {
            return true;
        }
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(this.serverVersion);
        if (artifactVersion.getMajorVersion() < 4) {
            return true;
        }
        return artifactVersion.getMajorVersion() == 4 && artifactVersion.getMinorVersion() < 5;
    }

    private boolean supportsNewDependencyProperty() {
        return !this.isVersionPriorTo5Dot0();
    }

    boolean isVersionPriorTo5Dot2() {
        if (this.serverVersion == null) {
            return true;
        }
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(this.serverVersion);
        if (artifactVersion.getMajorVersion() < 5) {
            return true;
        }
        return artifactVersion.getMajorVersion() == 5 && artifactVersion.getMinorVersion() < 2;
    }

    boolean isVersionPriorTo5Dot0() {
        if (this.serverVersion == null) {
            return true;
        }
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(this.serverVersion);
        return artifactVersion.getMajorVersion() < 5;
    }
}

