/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.HttpClientFactory;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.HttpException;
import org.sonarsource.scanner.lib.internal.util.Utils;

public class ScannerHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerHttpClient.class);
    private static final String EXCEPTION_MESSAGE_MISSING_SLASH = "URL path must start with slash: %s";
    private HttpClient sharedHttpClient;
    private HttpConfig httpConfig;

    public void init(HttpConfig httpConfig) {
        this.init(httpConfig, HttpClientFactory.create(httpConfig));
    }

    void init(HttpConfig httpConfig, HttpClient httpClient) {
        this.httpConfig = httpConfig;
        this.sharedHttpClient = httpClient;
    }

    public void downloadFromRestApi(String urlPath, Path toFile) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getRestApiBaseUrl() + urlPath;
        this.downloadFile(url, toFile, true);
    }

    public void downloadFromWebApi(String urlPath, Path toFile) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getWebApiBaseUrl() + urlPath;
        this.downloadFile(url, toFile, true);
    }

    public void downloadFromExternalUrl(String url, Path toFile) {
        this.downloadFile(url, toFile, false);
    }

    private void downloadFile(String url, Path toFile, boolean authentication) {
        LOG.debug("Download {} to {}", (Object)url, (Object)toFile.toAbsolutePath());
        this.callUrl(url, authentication, "application/octet-stream", response -> {
            Object var3_4;
            block8: {
                InputStream in = (InputStream)response.body();
                try {
                    Files.copy(in, toFile, StandardCopyOption.REPLACE_EXISTING);
                    var3_4 = null;
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | RuntimeException e) {
                        Utils.deleteQuietly(toFile);
                        throw e;
                    }
                }
                in.close();
            }
            return var3_4;
        });
    }

    public String callRestApi(String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getRestApiBaseUrl() + urlPath;
        return this.callApi(url);
    }

    public String callWebApi(String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getWebApiBaseUrl() + urlPath;
        return this.callApi(url);
    }

    private String callApi(String url) {
        return this.callUrl(url, true, null, response -> {
            try (InputStream in = (InputStream)response.body();){
                String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
        });
    }

    private <G> G callUrl(String url, boolean authentication, @Nullable String acceptHeader, ResponseHandler<G> responseHandler) {
        return this.callUrlWithRedirects(url, authentication, acceptHeader, responseHandler);
    }

    private <G> G callUrlWithRedirects(String url, boolean authentication, @Nullable String acceptHeader, ResponseHandler<G> responseHandler) {
        return this.callUrlWithRedirectsAndProxyAuth(url, authentication, acceptHeader, responseHandler, 0, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <G> G callUrlWithRedirectsAndProxyAuth(String url, boolean authentication, @Nullable String acceptHeader, ResponseHandler<G> responseHandler, int redirectCount, boolean proxyAuthAttempted) {
        String errorBody;
        block16: {
            Instant start;
            HttpResponse<InputStream> response;
            block14: {
                G g;
                block15: {
                    Optional<String> locationHeader;
                    block12: {
                        G g2;
                        block13: {
                            if (redirectCount > 10) {
                                throw new IllegalStateException("Too many redirects (>10) for URL: " + url);
                            }
                            HttpRequest request = this.prepareRequest(url, acceptHeader, authentication, proxyAuthAttempted);
                            response = null;
                            start = Instant.now();
                            LOG.debug("--> {} {}", (Object)request.method(), (Object)request.uri());
                            response = this.sharedHttpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
                            if (response.statusCode() != 407 || proxyAuthAttempted || this.httpConfig.getProxyUser() == null) break block12;
                            LOG.debug("Received 407 Proxy Authentication Required, retrying with Proxy-Authorization header");
                            g2 = this.callUrlWithRedirectsAndProxyAuth(url, authentication, acceptHeader, responseHandler, redirectCount, true);
                            if (response == null) break block13;
                            LOG.debug("<-- {} {} ({}ms)", new Object[]{response.statusCode(), response.uri(), Duration.between(start, Instant.now()).toMillis()});
                        }
                        return g2;
                    }
                    if (!ScannerHttpClient.isRedirect(response.statusCode()) || !(locationHeader = response.headers().firstValue("Location")).isPresent()) break block14;
                    Object redirectUrl = locationHeader.get();
                    if (!((String)redirectUrl).startsWith("http")) {
                        URI originalUri = URI.create(url);
                        redirectUrl = originalUri.getScheme() + "://" + originalUri.getAuthority() + (String)redirectUrl;
                    }
                    g = this.callUrlWithRedirectsAndProxyAuth((String)redirectUrl, authentication, acceptHeader, responseHandler, redirectCount + 1, proxyAuthAttempted);
                    if (response == null) break block15;
                    LOG.debug("<-- {} {} ({}ms)", new Object[]{response.statusCode(), response.uri(), Duration.between(start, Instant.now()).toMillis()});
                }
                return g;
            }
            try {
                if (response.statusCode() < 200 || response.statusCode() >= 300) {
                    errorBody = ScannerHttpClient.tryReadBody(response);
                    throw new HttpException(URI.create(url).toURL(), response.statusCode(), errorBody);
                }
                errorBody = responseHandler.apply(Objects.requireNonNull(response, "Response is empty"));
                if (response == null) break block16;
            }
            catch (HttpException e) {
                try {
                    throw e;
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(String.format("Call to URL [%s] was interrupted: %s", url, e2.getMessage()), e2);
                    }
                    catch (Exception e3) {
                        throw new IllegalStateException(String.format("Call to URL [%s] failed: %s", url, e3.getMessage()), e3);
                    }
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        LOG.debug("<-- {} {} ({}ms)", new Object[]{response.statusCode(), response.uri(), Duration.between(start, Instant.now()).toMillis()});
                    }
                    throw throwable;
                }
            }
            LOG.debug("<-- {} {} ({}ms)", new Object[]{response.statusCode(), response.uri(), Duration.between(start, Instant.now()).toMillis()});
        }
        return (G)errorBody;
    }

    @CheckForNull
    private static String tryReadBody(HttpResponse<InputStream> response) {
        String errorBody = null;
        try (InputStream body = response.body();){
            errorBody = new String(body.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return errorBody;
    }

    private static boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308;
    }

    private HttpRequest prepareRequest(String url, @Nullable String acceptHeader, boolean authentication, boolean addProxyAuth) {
        Duration timeout = this.httpConfig.getResponseTimeout().isZero() ? this.httpConfig.getSocketTimeout() : this.httpConfig.getResponseTimeout();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().uri(URI.create(url)).timeout(timeout).header("User-Agent", this.httpConfig.getUserAgent());
        if (acceptHeader != null) {
            requestBuilder.header("Accept", acceptHeader);
        }
        if (authentication) {
            if (this.httpConfig.getToken() != null) {
                requestBuilder.header("Authorization", "Bearer " + this.httpConfig.getToken());
            } else if (this.httpConfig.getLogin() != null) {
                String credentials = this.httpConfig.getLogin() + ":" + (this.httpConfig.getPassword() != null ? this.httpConfig.getPassword() : "");
                String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
                requestBuilder.header("Authorization", "Basic " + encodedCredentials);
            }
        }
        if (addProxyAuth && this.httpConfig.getProxyUser() != null) {
            String proxyCredentials = this.httpConfig.getProxyUser() + ":" + (this.httpConfig.getProxyPassword() != null ? this.httpConfig.getProxyPassword() : "");
            String encodedProxyCredentials = Base64.getEncoder().encodeToString(proxyCredentials.getBytes(StandardCharsets.UTF_8));
            requestBuilder.header("Proxy-Authorization", "Basic " + encodedProxyCredentials);
        }
        return requestBuilder.build();
    }

    private static interface ResponseHandler<G> {
        public G apply(HttpResponse<InputStream> var1) throws IOException;
    }
}

