/*
 * SonarScanner Java Library
 * Copyright (C) 2011-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonarsource.scanner.lib.internal.facade.simulation;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.InternalProperties;
import org.sonarsource.scanner.lib.internal.facade.AbstractScannerEngineFacade;

public class SimulationScannerEngineFacade extends AbstractScannerEngineFacade {

  private static final Logger LOG = LoggerFactory.getLogger(SimulationScannerEngineFacade.class);

  public SimulationScannerEngineFacade(Map<String, String> bootstrapProperties, boolean isSonarCloud,
    @Nullable String serverVersion) {
    super(bootstrapProperties, isSonarCloud, serverVersion, false, null);
  }

  @Override
  protected boolean doAnalyze(Map<String, String> allProps) {
    String filePath = allProps.get(InternalProperties.SCANNER_DUMP_TO_FILE);
    writeProperties(filePath, allProps);
    LOG.info("Simulation mode. Configuration written to {}", new File(filePath).getAbsolutePath());
    return true;
  }

  private static void writeProperties(String filePath, Map<String, String> p) {
    // This is to have output file content sorted by key
    Properties props = new Properties() {
      @Override
      public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(new TreeSet<>(super.keySet()));
      }
    };
    props.putAll(p);
    try (OutputStream outputStream = Files.newOutputStream(Paths.get(filePath))) {
      props.store(outputStream, "# Generated by a SonarScanner");
    } catch (Exception e) {
      throw new IllegalStateException("Fail to export scanner properties", e);
    }
  }

  @Override
  public void close() throws Exception {
    // nothing to do
  }
}
