/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.android.build.gradle.api.BaseVariant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarQubeTask;
import org.sonarsource.scanner.api.Utils;

public class SonarQubePlugin
implements Plugin<Project> {
    private static final Pattern TEST_RESULT_FILE_PATTERN = Pattern.compile("TESTS?-.*\\.xml");
    static final Predicate<File> FILE_EXISTS = File::exists;
    private static final Predicate<File> IS_FILE = File::isFile;
    static final String SONAR_SOURCES_PROP = "sonar.sources";
    static final String SONAR_TESTS_PROP = "sonar.tests";
    static final String SONAR_JAVA_SOURCE_PROP = "sonar.java.source";
    static final String SONAR_JAVA_TARGET_PROP = "sonar.java.target";
    private Project targetProject;

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarQubeProperties> propertiesActions, Map<String, Object> properties) {
        SonarQubeProperties sqProperties = new SonarQubeProperties(properties);
        propertiesActions.execute(sqProperties);
    }

    public void apply(Project project) {
        this.targetProject = project;
        HashMap<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap = new HashMap<Project, ActionBroadcast<SonarQubeProperties>>();
        this.createTask(project, actionBroadcastMap);
        ActionBroadcast<SonarQubeProperties> actionBroadcast = SonarQubePlugin.addBroadcaster(actionBroadcastMap, project);
        project.subprojects(p -> {
            ActionBroadcast<SonarQubeProperties> action = SonarQubePlugin.addBroadcaster(actionBroadcastMap, p);
            p.getExtensions().create("sonarqube", SonarQubeExtension.class, new Object[]{action});
        });
        project.getExtensions().create("sonarqube", SonarQubeExtension.class, new Object[]{actionBroadcast});
    }

    private static ActionBroadcast<SonarQubeProperties> addBroadcaster(Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap, Project project) {
        ActionBroadcast<SonarQubeProperties> actionBroadcast = new ActionBroadcast<SonarQubeProperties>();
        actionBroadcastMap.put(project, actionBroadcast);
        return actionBroadcast;
    }

    private SonarQubeTask createTask(Project project, Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap) {
        SonarQubeTask sonarQubeTask = (SonarQubeTask)project.getTasks().create("sonarqube", SonarQubeTask.class);
        sonarQubeTask.setDescription("Analyzes " + project + " and its subprojects with SonarQube.");
        ConventionMapping conventionMapping = new DslObject((Object)sonarQubeTask).getConventionMapping();
        conventionMapping.map("properties", () -> {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            this.computeSonarProperties(project, properties, actionBroadcastMap, "");
            return properties;
        });
        Callable<Iterable> testTask = () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> p.getTasks().getByName("test")).collect(Collectors.toList());
        sonarQubeTask.dependsOn(new Object[]{testTask});
        Callable<Iterable> callable = () -> project.getAllprojects().stream().filter(p -> SonarQubePlugin.isAndroidProject(p) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> {
            BaseVariant variant = AndroidUtils.findVariant(p, ((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).getAndroidVariant());
            ArrayList<Task> allCompileTasks = new ArrayList<Task>();
            boolean unitTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, "compile" + SonarQubePlugin.capitalize(variant.getName()) + "UnitTestJavaWithJavac", allCompileTasks);
            boolean androidTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, "compile" + SonarQubePlugin.capitalize(variant.getName()) + "AndroidTestJavaWithJavac", allCompileTasks);
            if (!unitTestTaskDepAdded && !androidTestTaskDepAdded) {
                SonarQubePlugin.addTaskByName(p, "compile" + SonarQubePlugin.capitalize(variant.getName()) + "JavaWithJavac", allCompileTasks);
            }
            return allCompileTasks;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        sonarQubeTask.dependsOn(new Object[]{callable});
        return sonarQubeTask;
    }

    private static boolean addTaskByName(Project p, String name, List<Task> allCompileTasks) {
        try {
            allCompileTasks.add(p.getTasks().getByName(name));
            return true;
        }
        catch (UnknownTaskException e) {
            return false;
        }
    }

    private static String capitalize(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    private void computeSonarProperties(Project project, Map<String, Object> properties, Map<Project, ActionBroadcast<SonarQubeProperties>> sonarPropertiesActionBroadcastMap, String prefix) {
        SonarQubeExtension extension = (SonarQubeExtension)project.getExtensions().getByType(SonarQubeExtension.class);
        if (extension.isSkipProject()) {
            return;
        }
        LinkedHashMap<String, Object> rawProperties = new LinkedHashMap<String, Object>();
        this.addGradleDefaults(project, rawProperties);
        if (SonarQubePlugin.isAndroidProject(project)) {
            AndroidUtils.configureForAndroid(project, extension.getAndroidVariant(), rawProperties);
        }
        SonarQubePlugin.evaluateSonarPropertiesBlocks(sonarPropertiesActionBroadcastMap.get(project), rawProperties);
        if (project.equals(this.targetProject)) {
            SonarQubePlugin.addEnvironmentProperties(rawProperties);
            SonarQubePlugin.addSystemProperties(rawProperties);
        }
        rawProperties.putIfAbsent(SONAR_SOURCES_PROP, "");
        SonarQubePlugin.convertProperties(rawProperties, prefix, properties);
        List enabledChildProjects = project.getChildProjects().values().stream().filter(p -> !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).collect(Collectors.toList());
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (Project childProject : enabledChildProjects) {
            String moduleId = childProject.getPath();
            moduleIds.add(moduleId);
            String modulePrefix = prefix.length() > 0 ? prefix + "." + moduleId : moduleId;
            this.computeSonarProperties(childProject, properties, sonarPropertiesActionBroadcastMap, modulePrefix);
        }
        properties.put(SonarQubePlugin.convertKey("sonar.modules", prefix), moduleIds.stream().collect(Collectors.joining(",")));
    }

    private void addGradleDefaults(Project project, Map<String, Object> properties) {
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        if (project.equals(this.targetProject)) {
            properties.put("sonar.projectKey", SonarQubePlugin.getProjectKey(project));
            properties.put("sonar.working.directory", new File(project.getBuildDir(), "sonar"));
        } else {
            properties.put("sonar.moduleKey", SonarQubePlugin.getProjectKey(project));
        }
        SonarQubePlugin.configureForJava(project, properties);
        SonarQubePlugin.configureForGroovy(project, properties);
    }

    private static boolean isAndroidProject(Project project) {
        return project.getPlugins().hasPlugin("com.android.application") || project.getPlugins().hasPlugin("com.android.library") || project.getPlugins().hasPlugin("com.android.test");
    }

    private static void configureForJava(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> SonarQubePlugin.configureJdkSourceAndTarget(project, properties));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            boolean hasSourceOrTest = SonarQubePlugin.configureSourceDirsAndJavaClasspath(project, properties, false);
            if (hasSourceOrTest) {
                SonarQubePlugin.configureSourceEncoding(project, properties);
                Test testTask = (Test)project.getTasks().getByName("test");
                SonarQubePlugin.configureTestReports(testTask, properties);
                SonarQubePlugin.configureJaCoCoCoverageReport(testTask, false, project, properties);
            }
        });
    }

    private static void configureForGroovy(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(GroovyBasePlugin.class, groovyBasePlugin -> SonarQubePlugin.configureJdkSourceAndTarget(project, properties));
        project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> {
            boolean hasSourceOrTest = SonarQubePlugin.configureSourceDirsAndJavaClasspath(project, properties, true);
            if (hasSourceOrTest) {
                SonarQubePlugin.configureSourceEncoding(project, properties);
                Test testTask = (Test)project.getTasks().getByName("test");
                SonarQubePlugin.configureTestReports(testTask, properties);
                SonarQubePlugin.configureJaCoCoCoverageReport(testTask, true, project, properties);
            }
        });
    }

    private static void configureJaCoCoCoverageReport(Test testTask, boolean addForGroovy, Project project, Map<String, Object> properties) {
        project.getPlugins().withType(JacocoPlugin.class, jacocoPlugin -> {
            JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)testTask.getExtensions().getByType(JacocoTaskExtension.class);
            File destinationFile = jacocoTaskExtension.getDestinationFile();
            if (destinationFile.exists()) {
                properties.put("sonar.jacoco.reportPath", destinationFile);
                if (addForGroovy) {
                    properties.put("sonar.groovy.jacoco.reportPath", destinationFile);
                }
            }
        });
    }

    private static void configureTestReports(Test testTask, Map<String, Object> properties) {
        File testResultsDir = testTask.getReports().getJunitXml().getDestination();
        if (testResultsDir.isDirectory() && Arrays.asList(testResultsDir.list()).stream().anyMatch(file -> TEST_RESULT_FILE_PATTERN.matcher((CharSequence)file).matches())) {
            properties.put("sonar.junit.reportsPath", testResultsDir);
            properties.put("sonar.surefire.reportsPath", testResultsDir);
        }
    }

    private static boolean configureSourceDirsAndJavaClasspath(Project project, Map<String, Object> properties, boolean addForGroovy) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt("main");
        List sourceDirectories = SonarQubePlugin.nonEmptyOrNull(main.getAllSource().getSrcDirs().stream().filter(FILE_EXISTS).collect(Collectors.toList()));
        properties.put(SONAR_SOURCES_PROP, sourceDirectories);
        SourceSet test = (SourceSet)javaPluginConvention.getSourceSets().getAt("test");
        List testDirectories = SonarQubePlugin.nonEmptyOrNull(test.getAllSource().getSrcDirs().stream().filter(FILE_EXISTS).collect(Collectors.toList()));
        properties.put(SONAR_TESTS_PROP, testDirectories);
        File mainClassDir = main.getOutput().getClassesDir();
        Collection<File> mainLibraries = SonarQubePlugin.getLibraries(main);
        SonarQubePlugin.setMainClasspathProps(properties, addForGroovy, mainClassDir, mainLibraries);
        File testClassDir = test.getOutput().getClassesDir();
        Collection<File> testLibraries = SonarQubePlugin.getLibraries(test);
        SonarQubePlugin.setTestClasspathProps(properties, testClassDir, testLibraries);
        return sourceDirectories != null || testDirectories != null;
    }

    static void setMainClasspathProps(Map<String, Object> properties, boolean addForGroovy, @Nullable File mainClassDir, Collection<File> mainLibraries) {
        if (mainClassDir != null && mainClassDir.exists()) {
            SonarQubePlugin.appendProp(properties, "sonar.java.binaries", mainClassDir);
            if (addForGroovy) {
                SonarQubePlugin.appendProp(properties, "sonar.groovy.binaries", mainClassDir);
            }
            SonarQubePlugin.appendProp(properties, "sonar.binaries", mainClassDir);
        }
        SonarQubePlugin.appendProps(properties, "sonar.java.libraries", mainLibraries);
        SonarQubePlugin.appendProps(properties, "sonar.libraries", mainLibraries);
    }

    static void appendProps(Map<String, Object> properties, String key, Iterable valuesToAppend) {
        properties.putIfAbsent(key, new LinkedHashSet());
        StreamSupport.stream(valuesToAppend.spliterator(), false).forEach(v -> ((Collection)properties.get(key)).add(v.toString()));
    }

    static void appendProp(Map<String, Object> properties, String key, Object valueToAppend) {
        properties.putIfAbsent(key, new LinkedHashSet());
        ((Collection)properties.get(key)).add(valueToAppend.toString());
    }

    static void setTestClasspathProps(Map<String, Object> properties, @Nullable File testClassDir, Collection<File> testLibraries) {
        if (testClassDir != null && testClassDir.exists()) {
            SonarQubePlugin.appendProp(properties, "sonar.java.test.binaries", testClassDir);
        }
        SonarQubePlugin.appendProps(properties, "sonar.java.test.libraries", testLibraries);
    }

    private static void configureSourceEncoding(Project project, Map<String, Object> properties) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            String encoding = compile.getOptions().getEncoding();
            if (encoding != null) {
                properties.put("sonar.sourceEncoding", encoding);
            }
        });
    }

    private static void configureJdkSourceAndTarget(Project project, Map<String, Object> properties) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        properties.put(SONAR_JAVA_SOURCE_PROP, javaPluginConvention.getSourceCompatibility());
        properties.put(SONAR_JAVA_TARGET_PROP, javaPluginConvention.getTargetCompatibility());
    }

    private static String getProjectKey(Project project) {
        String rootKey;
        Project rootProject = project.getRootProject();
        String rootProjectName = rootProject.getName();
        String rootGroup = rootProject.getGroup().toString();
        String string = rootKey = rootGroup.isEmpty() ? rootProjectName : rootGroup + ":" + rootProjectName;
        if (project == rootProject) {
            return rootKey;
        }
        return rootKey + project.getPath();
    }

    private static void addEnvironmentProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> e : Utils.loadEnvironmentProperties(System.getenv()).entrySet()) {
            properties.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    private static void addSystemProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private static Collection<File> getLibraries(SourceSet main) {
        File fxRuntimeJar;
        List<File> libraries = main.getCompileClasspath().getFiles().stream().filter(IS_FILE).collect(Collectors.toList());
        File runtimeJar = SonarQubePlugin.getRuntimeJar();
        if (runtimeJar != null) {
            libraries.add(runtimeJar);
        }
        if ((fxRuntimeJar = SonarQubePlugin.getFxRuntimeJar()) != null) {
            libraries.add(fxRuntimeJar);
        }
        return libraries;
    }

    private static File getRuntimeJar() {
        try {
            File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            File runtimeJar = new File(javaBase, "lib/rt.jar");
            if (runtimeJar.exists()) {
                return runtimeJar;
            }
            runtimeJar = new File(javaBase, "jre/lib/rt.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static File getFxRuntimeJar() {
        try {
            File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            File runtimeJar = new File(javaBase, "lib/ext/jfxrt.jar");
            if (runtimeJar.exists()) {
                return runtimeJar;
            }
            runtimeJar = new File(javaBase, "jre/lib/ext/jfxrt.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = SonarQubePlugin.convertValue(entry.getValue());
            if (value == null) continue;
            properties.put(SonarQubePlugin.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private static String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private static String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            String joined = StreamSupport.stream(((Iterable)value).spliterator(), false).map(SonarQubePlugin::convertValue).filter(v -> v != null).collect(Collectors.joining(","));
            return joined.isEmpty() ? null : joined;
        }
        return value.toString();
    }

    @Nullable
    public static <T> List<T> nonEmptyOrNull(Collection<T> collection) {
        List<T> list = Collections.unmodifiableList(new ArrayList<T>(collection));
        return list.isEmpty() ? null : list;
    }
}

