/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.TestPlugin;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.PluginCollection;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.sonarqube.gradle.SonarQubePlugin;

class AndroidUtils {
    private static final Logger LOGGER = Logging.getLogger(AndroidUtils.class);

    private AndroidUtils() {
    }

    static void configureForAndroid(Project project, String userConfiguredBuildVariantName, Map<String, Object> properties) {
        BaseVariant variant = AndroidUtils.findVariant(project, userConfiguredBuildVariantName);
        if (variant != null) {
            AndroidUtils.configureForAndroid(project, variant, properties);
        }
    }

    private static void configureForAndroid(Project project, BaseVariant variant, Map<String, Object> properties) {
        List<File> bootClassPath = AndroidUtils.getBootClasspath(project);
        if (project.getPlugins().hasPlugin("com.android.test")) {
            AndroidUtils.populateSonarQubeProps(properties, bootClassPath, variant, true);
        } else {
            AndroidUtils.populateSonarQubeProps(properties, bootClassPath, variant, false);
            if (variant instanceof TestedVariant) {
                TestVariant testVariant;
                UnitTestVariant unitTestVariant = ((TestedVariant)variant).getUnitTestVariant();
                if (unitTestVariant != null) {
                    AndroidUtils.populateSonarQubeProps(properties, bootClassPath, (BaseVariant)unitTestVariant, true);
                }
                if ((testVariant = ((TestedVariant)variant).getTestVariant()) != null) {
                    AndroidUtils.populateSonarQubeProps(properties, bootClassPath, (BaseVariant)testVariant, true);
                }
            }
        }
    }

    @Nullable
    static List<File> getBootClasspath(Project project) {
        TestExtension androidExtension;
        LibraryExtension androidExtension2;
        AppExtension androidExtension3;
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty() && (androidExtension3 = (AppExtension)project.getExtensions().getByType(AppExtension.class)) != null) {
            return androidExtension3.getBootClasspath();
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty() && (androidExtension2 = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class)) != null) {
            return androidExtension2.getBootClasspath();
        }
        PluginCollection testPlugins = project.getPlugins().withType(TestPlugin.class);
        if (!testPlugins.isEmpty() && (androidExtension = (TestExtension)project.getExtensions().getByType(TestExtension.class)) != null) {
            return androidExtension.getBootClasspath();
        }
        return null;
    }

    @Nullable
    static String getTestBuildType(Project project) {
        LibraryExtension androidExtension;
        AppExtension androidExtension2;
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty() && (androidExtension2 = (AppExtension)project.getExtensions().getByType(AppExtension.class)) != null) {
            return androidExtension2.getTestBuildType();
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty() && (androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class)) != null) {
            return androidExtension.getTestBuildType();
        }
        return null;
    }

    @Nullable
    static BaseVariant findVariant(Project project, @Nullable String userConfiguredBuildVariantName) {
        TestExtension androidExtension;
        LibraryExtension androidExtension2;
        AppExtension androidExtension3;
        String testBuildType = AndroidUtils.getTestBuildType(project);
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty() && (androidExtension3 = (AppExtension)project.getExtensions().getByType(AppExtension.class)) != null) {
            return AndroidUtils.findVariant(androidExtension3.getApplicationVariants().stream().collect(Collectors.toList()), testBuildType, userConfiguredBuildVariantName);
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty() && (androidExtension2 = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class)) != null) {
            return AndroidUtils.findVariant(androidExtension2.getLibraryVariants().stream().collect(Collectors.toList()), testBuildType, userConfiguredBuildVariantName);
        }
        PluginCollection testPlugins = project.getPlugins().withType(TestPlugin.class);
        if (!testPlugins.isEmpty() && (androidExtension = (TestExtension)project.getExtensions().getByType(TestExtension.class)) != null) {
            return AndroidUtils.findVariant(androidExtension.getApplicationVariants().stream().collect(Collectors.toList()), testBuildType, userConfiguredBuildVariantName);
        }
        return null;
    }

    @Nullable
    static BaseVariant findVariant(List<BaseVariant> candidates, @Nullable String testBuildType, @Nullable String userConfiguredBuildVariantName) {
        if (candidates.isEmpty()) {
            return null;
        }
        if (userConfiguredBuildVariantName == null) {
            Optional<BaseVariant> firstDebug = candidates.stream().filter(v -> testBuildType != null && testBuildType.equals(v.getBuildType().getName())).findFirst();
            BaseVariant result = firstDebug.isPresent() ? firstDebug.get() : candidates.get(0);
            LOGGER.info("No variant name specified to be used by SonarQube. Default to '{}'", (Object)result.getName());
            return result;
        }
        Optional<BaseVariant> result = candidates.stream().filter(v -> userConfiguredBuildVariantName.equals(v.getName())).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException("Unable to find variant '" + userConfiguredBuildVariantName + "' to use for SonarQube configuration");
    }

    @NotNull
    private static void populateSonarQubeProps(Map<String, Object> properties, List<File> bootClassPath, BaseVariant variant, boolean isTest) {
        AbstractCompile javaCompiler;
        List srcDirs = variant.getSourceSets().stream().map(AndroidUtils::getFilesFromSourceSet).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        List sourcesOrTests = SonarQubePlugin.nonEmptyOrNull(srcDirs.stream().filter(SonarQubePlugin.FILE_EXISTS).collect(Collectors.toList()));
        if (sourcesOrTests != null) {
            SonarQubePlugin.appendProps(properties, isTest ? "sonar.tests" : "sonar.sources", sourcesOrTests);
        }
        if ((javaCompiler = AndroidUtils.getJavaCompiler(variant)) == null) {
            LOGGER.warn("Unable to find Java compiler on variant '{}'. Is Jack toolchain used? SonarQube analysis will be less accurate without bytecode.", (Object)variant.getName());
        }
        if (javaCompiler != null) {
            properties.put("sonar.java.source", javaCompiler.getSourceCompatibility());
            properties.put("sonar.java.target", javaCompiler.getTargetCompatibility());
        }
        LinkedHashSet<File> libraries = new LinkedHashSet<File>();
        libraries.addAll(bootClassPath);
        if (variant instanceof ApkVariant) {
            libraries.addAll(((ApkVariant)variant).getCompileLibraries());
        }
        if (javaCompiler != null) {
            libraries.addAll(javaCompiler.getClasspath().filter(File::exists).getFiles());
        }
        if (isTest) {
            SonarQubePlugin.setTestClasspathProps(properties, javaCompiler != null ? javaCompiler.getDestinationDir() : null, libraries);
        } else {
            SonarQubePlugin.setMainClasspathProps(properties, false, javaCompiler != null ? javaCompiler.getDestinationDir() : null, libraries);
        }
    }

    @Nullable
    private static AbstractCompile getJavaCompiler(BaseVariant variant) {
        return variant.getJavaCompile();
    }

    private static List<File> getFilesFromSourceSet(SourceProvider sourceSet) {
        ArrayList<File> srcDirs = new ArrayList<File>();
        srcDirs.add(sourceSet.getManifestFile());
        srcDirs.addAll(sourceSet.getCDirectories());
        srcDirs.addAll(sourceSet.getAidlDirectories());
        srcDirs.addAll(sourceSet.getAssetsDirectories());
        srcDirs.addAll(sourceSet.getCppDirectories());
        srcDirs.addAll(sourceSet.getJavaDirectories());
        srcDirs.addAll(sourceSet.getRenderscriptDirectories());
        srcDirs.addAll(sourceSet.getResDirectories());
        srcDirs.addAll(sourceSet.getResourcesDirectories());
        return srcDirs;
    }
}

