/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.Locale;
import java.util.Properties;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.cli.Cli;
import org.sonarsource.scanner.cli.Conf;
import org.sonarsource.scanner.cli.Exit;
import org.sonarsource.scanner.cli.Logs;
import org.sonarsource.scanner.cli.ScannerFactory;
import org.sonarsource.scanner.cli.Stats;
import org.sonarsource.scanner.cli.SystemInfo;

public class Main {
    private static final String SEPARATOR = "------------------------------------------------------------------------";
    private final Exit exit;
    private final Cli cli;
    private final Conf conf;
    private EmbeddedScanner embeddedScanner;
    private final ScannerFactory runnerFactory;
    private final Logs logger;

    Main(Exit exit, Cli cli, Conf conf, ScannerFactory runnerFactory, Logs logger) {
        this.exit = exit;
        this.cli = cli;
        this.conf = conf;
        this.runnerFactory = runnerFactory;
        this.logger = logger;
    }

    public static void main(String[] args) {
        Logs logs = new Logs(System.out, System.err);
        Exit exit = new Exit();
        Cli cli = new Cli(exit, logs).parse(args);
        Main main = new Main(exit, cli, new Conf(cli, logs, System.getenv()), new ScannerFactory(logs), logs);
        main.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        Stats stats = new Stats(this.logger).start();
        int status = 1;
        try {
            Properties p = this.conf.properties();
            this.checkSkip(p);
            this.configureLogging(p);
            this.init(p);
            this.embeddedScanner.start();
            if (Main.isSonarCloud(p)) {
                this.logger.info("Analyzing on SonarCloud");
            } else {
                String serverVersion = this.embeddedScanner.serverVersion();
                this.logger.info(String.format("Analyzing on SonarQube server %s", serverVersion));
            }
            this.execute(stats, p);
            status = 0;
        }
        catch (Throwable e) {
            this.displayExecutionResult(stats, "FAILURE");
            this.showError("Error during SonarScanner execution", e, this.cli.isDebugEnabled());
            status = Main.isUserError(e) ? 2 : 1;
        }
        finally {
            this.exit.exit(status);
        }
    }

    static boolean isSonarCloud(Properties props) {
        String hostUrl = props.getProperty("sonar.host.url");
        if (hostUrl != null) {
            return hostUrl.toLowerCase(Locale.ENGLISH).contains("sonarcloud");
        }
        return false;
    }

    private void checkSkip(Properties properties) {
        if ("true".equalsIgnoreCase(properties.getProperty("sonar.scanner.skip"))) {
            this.logger.info("SonarScanner analysis skipped");
            this.exit.exit(0);
        }
    }

    private void init(Properties p) {
        SystemInfo.print(this.logger);
        if (this.cli.isDisplayVersionOnly()) {
            this.exit.exit(0);
        }
        this.embeddedScanner = this.runnerFactory.create(p, this.cli.getInvokedFrom());
    }

    private void configureLogging(Properties props) {
        if ("true".equals(props.getProperty("sonar.verbose")) || "DEBUG".equalsIgnoreCase(props.getProperty("sonar.log.level")) || "TRACE".equalsIgnoreCase(props.getProperty("sonar.log.level"))) {
            this.logger.setDebugEnabled(true);
        }
    }

    private void execute(Stats stats, Properties p) {
        this.embeddedScanner.execute(p);
        this.displayExecutionResult(stats, "SUCCESS");
    }

    private void displayExecutionResult(Stats stats, String resultMsg) {
        this.logger.info(SEPARATOR);
        this.logger.info("EXECUTION " + resultMsg);
        this.logger.info(SEPARATOR);
        stats.stop();
        this.logger.info(SEPARATOR);
    }

    private void showError(String message, Throwable e, boolean debug) {
        if (debug || !Main.isUserError(e)) {
            this.logger.error(message, e);
        } else {
            this.logger.error(message);
            this.logger.error(e.getMessage());
            String previousMsg = "";
            for (Throwable cause = e.getCause(); cause != null && cause.getMessage() != null && !cause.getMessage().equals(previousMsg); cause = cause.getCause()) {
                this.logger.error("Caused by: " + cause.getMessage());
                previousMsg = cause.getMessage();
            }
        }
        if (!this.cli.isDebugEnabled()) {
            this.logger.error("");
            this.suggestDebugMode();
        }
    }

    private static boolean isUserError(Throwable e) {
        return "org.sonar.api.utils.MessageException".equals(e.getClass().getName());
    }

    private void suggestDebugMode() {
        if (!this.cli.isEmbedded()) {
            this.logger.error("Re-run SonarScanner using the -X switch to enable full debug logging.");
        }
    }
}

