/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sonarsource.scanner.api.Utils;
import org.sonarsource.scanner.api.internal.cache.Logger;

class TempCleaning {
    static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    final Path tempDir;
    private final Logger logger;

    TempCleaning(Logger logger) {
        this(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), logger);
    }

    TempCleaning(Path tempDir, Logger logger) {
        this.logger = logger;
        this.tempDir = tempDir;
    }

    void clean() {
        this.logger.debug("Start temp cleaning...");
        long cutoff = System.currentTimeMillis() - 86400000L;
        try {
            Files.list(this.tempDir).filter(p -> p.getFileName().toString().startsWith("sonar-runner-batch")).filter(p -> TempCleaning.lastModifiedTime(p) < cutoff).forEach(Utils::deleteQuietly);
            this.logger.debug("Temp cleaning done");
        }
        catch (IOException e) {
            this.logger.warn("Failed to clean files in " + this.tempDir.toString() + ": " + e.getMessage());
        }
    }

    private static long lastModifiedTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return System.currentTimeMillis();
        }
    }
}

