/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.scanner.api.internal.BootstrapIndexDownloader;
import org.sonarsource.scanner.api.internal.JarExtractor;
import org.sonarsource.scanner.api.internal.ServerConnection;
import org.sonarsource.scanner.api.internal.cache.FileCache;
import org.sonarsource.scanner.api.internal.cache.Logger;

class JarDownloader {
    private final FileCache fileCache;
    private final JarExtractor jarExtractor;
    private final Logger logger;
    private final ScannerFileDownloader scannerFileDownloader;
    private final BootstrapIndexDownloader bootstrapIndexDownloader;

    JarDownloader(ScannerFileDownloader scannerFileDownloader, BootstrapIndexDownloader bootstrapIndexDownloader, FileCache fileCache, JarExtractor jarExtractor, Logger logger) {
        this.scannerFileDownloader = scannerFileDownloader;
        this.bootstrapIndexDownloader = bootstrapIndexDownloader;
        this.logger = logger;
        this.fileCache = fileCache;
        this.jarExtractor = jarExtractor;
    }

    List<File> download() {
        ArrayList<File> files = new ArrayList<File>();
        this.logger.debug("Extract sonar-scanner-api-batch in temp...");
        files.add(this.jarExtractor.extractToTemp("sonar-scanner-api-batch").toFile());
        files.addAll(this.getScannerEngineFiles());
        return files;
    }

    private List<File> getScannerEngineFiles() {
        Collection<BootstrapIndexDownloader.JarEntry> index = this.bootstrapIndexDownloader.getIndex();
        return index.stream().map(jar -> this.fileCache.get(jar.getFilename(), jar.getHash(), this.scannerFileDownloader)).collect(Collectors.toList());
    }

    static class ScannerFileDownloader
    implements FileCache.Downloader {
        private final ServerConnection connection;

        ScannerFileDownloader(ServerConnection conn) {
            this.connection = conn;
        }

        @Override
        public void download(String filename, File toFile) throws IOException {
            this.connection.downloadFile(String.format("/batch/file?name=%s", filename), toFile.toPath());
        }
    }
}

