/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal.batch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.sonarsource.scanner.api.internal.batch.BatchFactory;
import org.sonarsource.scanner.api.internal.batch.DefaultBatchFactory;
import org.sonarsource.scanner.api.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.api.internal.batch.LogOutput;

public class BatchIsolatedLauncher
implements IsolatedLauncher {
    private final BatchFactory factory;

    public BatchIsolatedLauncher() {
        this(new DefaultBatchFactory());
    }

    public BatchIsolatedLauncher(BatchFactory factory) {
        this.factory = factory;
    }

    public void execute(Map<String, String> properties, LogOutput logOutput) {
        this.factory.createBatch(properties, logOutput).execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersion() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("sq-version.txt");
        if (is == null) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String string = br.readLine();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }
}

