/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import javax.annotation.Nullable;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.debt.internal.DefaultDebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.MessageException;

class DefaultDebtRemediationFunctions
implements RulesDefinition.DebtRemediationFunctions {
    private final String repoKey;
    private final String key;

    DefaultDebtRemediationFunctions(String repoKey, String key) {
        this.repoKey = repoKey;
        this.key = key;
    }

    @Override
    public DebtRemediationFunction linear(String gapMultiplier) {
        return this.create(DebtRemediationFunction.Type.LINEAR, gapMultiplier, null);
    }

    @Override
    public DebtRemediationFunction linearWithOffset(String gapMultiplier, String baseEffort) {
        return this.create(DebtRemediationFunction.Type.LINEAR_OFFSET, gapMultiplier, baseEffort);
    }

    @Override
    public DebtRemediationFunction constantPerIssue(String baseEffort) {
        return this.create(DebtRemediationFunction.Type.CONSTANT_ISSUE, null, baseEffort);
    }

    @Override
    public DebtRemediationFunction create(DebtRemediationFunction.Type type, @Nullable String gapMultiplier, @Nullable String baseEffort) {
        try {
            return new DefaultDebtRemediationFunction(type, gapMultiplier, baseEffort);
        }
        catch (Exception e) {
            throw MessageException.of(String.format("The rule '%s:%s' is invalid : %s ", this.repoKey, this.key, e.getMessage()));
        }
    }
}

