/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Preconditions;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class ResourceTypeTree {
    private final List<ResourceType> types;
    private final Map<String, List<String>> relations;
    private final ResourceType root;

    private ResourceTypeTree(Builder builder) {
        this.types = Collections.unmodifiableList(new ArrayList<ResourceType>(builder.types));
        this.relations = Collections.unmodifiableMap(builder.relations);
        this.root = builder.root;
    }

    public List<ResourceType> getTypes() {
        return this.types;
    }

    public List<String> getChildren(String qualifier) {
        return this.relations.getOrDefault(qualifier, Collections.emptyList());
    }

    public ResourceType getRootType() {
        return this.root;
    }

    public List<String> getLeaves() {
        return this.relations.values().stream().flatMap(Collection::stream).filter(qualifier -> !this.relations.containsKey(qualifier)).collect(Collectors.toList());
    }

    public String toString() {
        return this.root.getQualifier();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceType> types = new ArrayList<ResourceType>();
        private Map<String, List<String>> relations = new HashMap<String, List<String>>();
        private List<String> children = new ArrayList<String>();
        private ResourceType root;

        private Builder() {
        }

        public Builder addType(ResourceType type) {
            Objects.requireNonNull(type);
            Preconditions.checkArgument(!this.types.contains(type), String.format("%s is already registered", type.getQualifier()));
            this.types.add(type);
            return this;
        }

        public Builder addRelations(String parentQualifier, String ... childrenQualifiers) {
            Objects.requireNonNull(parentQualifier);
            Objects.requireNonNull(childrenQualifiers);
            Preconditions.checkArgument(childrenQualifiers.length > 0, "childrenQualifiers can't be empty");
            this.relations.computeIfAbsent(parentQualifier, x -> new ArrayList()).addAll(Arrays.asList(childrenQualifiers));
            this.children.addAll(Arrays.asList(childrenQualifiers));
            return this;
        }

        public ResourceTypeTree build() {
            for (ResourceType type : this.types) {
                if (this.children.contains(type.getQualifier())) continue;
                this.root = type;
                break;
            }
            return new ResourceTypeTree(this);
        }
    }
}

