/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Profiler;

class DefaultProfiler
extends Profiler {
    private static final String CONTEXT_SEPARATOR = " | ";
    private static final String DONE_SUFFIX = " (done)";
    private final LinkedHashMap<String, Object> context = new LinkedHashMap();
    private final Logger logger;
    private long startTime = 0L;
    private String startMessage = null;

    public DefaultProfiler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public Profiler start() {
        this.startTime = System2.INSTANCE.now();
        this.startMessage = null;
        return this;
    }

    @Override
    public Profiler startTrace(String message) {
        this.startTime = System2.INSTANCE.now();
        this.startMessage = message;
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        this.appendContext(sb);
        this.logger.trace(sb.toString());
        return this;
    }

    @Override
    public Profiler startDebug(String message) {
        this.startTime = System2.INSTANCE.now();
        this.startMessage = message;
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        this.appendContext(sb);
        this.logger.debug(sb.toString());
        return this;
    }

    @Override
    public Profiler startInfo(String message) {
        this.startTime = System2.INSTANCE.now();
        this.startMessage = message;
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        this.appendContext(sb);
        this.logger.info(sb.toString());
        return this;
    }

    @Override
    public Profiler stopTrace() {
        return this.doStopWithoutMessage(LoggerLevel.TRACE, DONE_SUFFIX);
    }

    @Override
    public Profiler stopDebug() {
        return this.doStopWithoutMessage(LoggerLevel.DEBUG, DONE_SUFFIX);
    }

    @Override
    public Profiler stopInfo() {
        return this.stopInfo(false);
    }

    @Override
    public Profiler stopInfo(boolean cacheUsed) {
        String suffix = cacheUsed ? " (done from cache)" : DONE_SUFFIX;
        return this.doStopWithoutMessage(LoggerLevel.INFO, suffix);
    }

    private Profiler doStopWithoutMessage(LoggerLevel level, String suffix) {
        if (this.startMessage == null) {
            throw new IllegalStateException("Profiler#stopXXX() can't be called without any message defined in start methods");
        }
        this.doStop(level, this.startMessage, suffix);
        return this;
    }

    @Override
    public Profiler stopTrace(String message) {
        this.doStop(LoggerLevel.TRACE, message, "");
        return this;
    }

    @Override
    public Profiler stopDebug(String message) {
        this.doStop(LoggerLevel.DEBUG, message, "");
        return this;
    }

    @Override
    public Profiler stopInfo(String message) {
        this.doStop(LoggerLevel.INFO, message, "");
        return this;
    }

    private void doStop(LoggerLevel level, @Nullable String message, String messageSuffix) {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Profiler must be started before being stopped");
        }
        long duration = System2.INSTANCE.now() - this.startTime;
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty(message)) {
            sb.append(message);
            sb.append(messageSuffix);
            sb.append(CONTEXT_SEPARATOR);
        }
        sb.append("time=").append(duration).append("ms");
        this.appendContext(sb);
        this.logger.log(level, sb.toString());
        this.startTime = 0L;
        this.startMessage = null;
        this.context.clear();
    }

    private void appendContext(StringBuilder sb) {
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            if (sb.length() > 0) {
                sb.append(CONTEXT_SEPARATOR);
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
    }

    @Override
    public Profiler addContext(String key, @Nullable Object value) {
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
        return this;
    }
}

