/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.sonar.api.utils.SonarException;

public final class ManifestUtils {
    private ManifestUtils() {
    }

    public static List<String> getPropertyValues(ClassLoader classloader, String key) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            Enumeration<URL> resources = classloader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attributes = manifest.getMainAttributes();
                String value = attributes.getValue(key);
                if (value == null) continue;
                values.add(value);
            }
        }
        catch (IOException e) {
            throw new SonarException("Fail to load manifests from classloader: " + String.valueOf(classloader), e);
        }
        return values;
    }
}

