/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.RuleType;

public class ImpactMapper {
    static final List<SoftwareQuality> ORDERED_SOFTWARE_QUALITIES = List.of(SoftwareQuality.SECURITY, SoftwareQuality.RELIABILITY, SoftwareQuality.MAINTAINABILITY);

    private ImpactMapper() {
    }

    public static SoftwareQuality convertToSoftwareQuality(RuleType ruleType) {
        switch (ruleType) {
            case CODE_SMELL: {
                return SoftwareQuality.MAINTAINABILITY;
            }
            case BUG: {
                return SoftwareQuality.RELIABILITY;
            }
            case VULNERABILITY: {
                return SoftwareQuality.SECURITY;
            }
            case SECURITY_HOTSPOT: {
                throw new IllegalStateException("Can not map Security Hotspot to Software Quality");
            }
        }
        throw new IllegalStateException("Unknown rule type");
    }

    public static RuleType convertToRuleType(SoftwareQuality softwareQuality) {
        switch (softwareQuality) {
            case MAINTAINABILITY: {
                return RuleType.CODE_SMELL;
            }
            case RELIABILITY: {
                return RuleType.BUG;
            }
            case SECURITY: {
                return RuleType.VULNERABILITY;
            }
        }
        throw new IllegalStateException("Unknown software quality");
    }

    public static String convertToRuleSeverity(Severity severity) {
        switch (severity) {
            case BLOCKER: {
                return "BLOCKER";
            }
            case HIGH: {
                return "CRITICAL";
            }
            case MEDIUM: {
                return "MAJOR";
            }
            case LOW: {
                return "MINOR";
            }
            case INFO: {
                return "INFO";
            }
        }
        throw new IllegalStateException("This severity value " + String.valueOf((Object)severity) + " is illegal.");
    }

    @Deprecated(since="10.14")
    public static String convertToDeprecatedSeverity(Severity severity) {
        return ImpactMapper.convertToRuleSeverity(severity);
    }

    public static Severity convertToImpactSeverity(String ruleSeverity) {
        switch (ruleSeverity) {
            case "BLOCKER": {
                return Severity.BLOCKER;
            }
            case "CRITICAL": {
                return Severity.HIGH;
            }
            case "MAJOR": {
                return Severity.MEDIUM;
            }
            case "MINOR": {
                return Severity.LOW;
            }
            case "INFO": {
                return Severity.INFO;
            }
        }
        throw new IllegalStateException("This severity value " + ruleSeverity + " is illegal.");
    }

    public static Map.Entry<SoftwareQuality, Severity> getBestImpactForBackmapping(Map<SoftwareQuality, Severity> impacts) {
        return impacts.entrySet().stream().min(Comparator.comparing(i -> ORDERED_SOFTWARE_QUALITIES.indexOf(i.getKey()))).orElseThrow(() -> new IllegalArgumentException("There is no impact to choose from."));
    }
}

