/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.internal.DefaultNewRepository;
import org.sonar.api.server.rule.internal.DefaultNewRule;
import org.sonar.api.server.rule.internal.DefaultRule;
import org.sonar.api.utils.log.Loggers;

@Immutable
public class DefaultRepository
implements RulesDefinition.Repository {
    private final String key;
    private final String language;
    private final String name;
    private final boolean isExternal;
    private final Map<String, RulesDefinition.Rule> rulesByKey;

    public DefaultRepository(DefaultNewRepository newRepository, @Nullable RulesDefinition.Repository mergeInto) {
        this.key = newRepository.key();
        this.language = newRepository.language();
        this.isExternal = newRepository.isExternal();
        HashMap<String, RulesDefinition.Rule> ruleBuilder = new HashMap<String, RulesDefinition.Rule>();
        if (mergeInto != null) {
            if (!StringUtils.equals(newRepository.language(), mergeInto.language()) || !StringUtils.equals(newRepository.key(), mergeInto.key())) {
                throw new IllegalArgumentException(String.format("Bug - language and key of the repositories to be merged should be the sames: %s and %s", newRepository, mergeInto));
            }
            this.name = StringUtils.defaultIfBlank(mergeInto.name(), newRepository.name());
            for (RulesDefinition.Rule rule : mergeInto.rules()) {
                if (!newRepository.key().startsWith("common-") && ruleBuilder.containsKey(rule.key())) {
                    Loggers.get(this.getClass()).warn("The rule '{}' of repository '{}' is declared several times", (Object)rule.key(), (Object)mergeInto.key());
                }
                ruleBuilder.put(rule.key(), rule);
            }
        } else {
            this.name = newRepository.name();
        }
        for (RulesDefinition.NewRule newRule : newRepository.newRules().values()) {
            DefaultNewRule defaultNewRule = (DefaultNewRule)newRule;
            defaultNewRule.validate();
            ruleBuilder.put(newRule.key(), new DefaultRule(this, defaultNewRule));
        }
        this.rulesByKey = Collections.unmodifiableMap(ruleBuilder);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String language() {
        return this.language;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    @CheckForNull
    public RulesDefinition.Rule rule(String ruleKey) {
        return this.rulesByKey.get(ruleKey);
    }

    @Override
    public List<RulesDefinition.Rule> rules() {
        return Collections.unmodifiableList(new ArrayList<RulesDefinition.Rule>(this.rulesByKey.values()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRepository that = (DefaultRepository)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Repository{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", language='").append(this.language).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

