/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleDescriptionSection;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.internal.DefaultNewRepository;
import org.sonar.api.server.rule.internal.DefaultRepository;
import org.sonar.api.utils.Preconditions;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ServerSide
@ComputeEngineSide
@SonarLintSide
@ExtensionPoint
public interface RulesDefinition {
    public void define(Context var1);

    @Immutable
    public static interface Param {
        public String key();

        public String name();

        @Nullable
        public String description();

        @Nullable
        public String defaultValue();

        public RuleParamType type();
    }

    public static abstract class NewParam {
        public abstract String key();

        public abstract NewParam setName(@Nullable String var1);

        public abstract NewParam setType(RuleParamType var1);

        public abstract NewParam setDescription(@Nullable String var1);

        public abstract NewParam setDefaultValue(@Nullable String var1);
    }

    @Immutable
    public static abstract class Rule {
        public abstract Repository repository();

        @CheckForNull
        public abstract String pluginKey();

        public abstract String key();

        public abstract String name();

        public abstract RuleScope scope();

        public abstract RuleType type();

        @CheckForNull
        public abstract CleanCodeAttribute cleanCodeAttribute();

        public abstract String severity();

        public abstract Map<SoftwareQuality, Severity> defaultImpacts();

        public abstract List<RuleDescriptionSection> ruleDescriptionSections();

        public abstract Set<String> educationPrincipleKeys();

        @CheckForNull
        public abstract String htmlDescription();

        @Deprecated(since="9.6", forRemoval=true)
        @CheckForNull
        public abstract String markdownDescription();

        public abstract boolean template();

        public abstract boolean activatedByDefault();

        public abstract RuleStatus status();

        @CheckForNull
        public abstract DebtRemediationFunction debtRemediationFunction();

        @CheckForNull
        public abstract String gapDescription();

        @CheckForNull
        public abstract Param param(String var1);

        public abstract List<Param> params();

        public abstract Set<String> tags();

        public abstract Set<String> securityStandards();

        public abstract Set<RuleKey> deprecatedRuleKeys();

        @CheckForNull
        public abstract String internalKey();
    }

    public static abstract class NewRule {
        public abstract String key();

        @CheckForNull
        public abstract RuleScope scope();

        public abstract NewRule setScope(RuleScope var1);

        public abstract NewRule setName(String var1);

        public abstract NewRule setTemplate(boolean var1);

        public abstract NewRule setActivatedByDefault(boolean var1);

        public abstract NewRule setSeverity(String var1);

        public abstract NewRule addDefaultImpact(SoftwareQuality var1, Severity var2);

        public abstract NewRule setType(RuleType var1);

        public abstract NewRule setCleanCodeAttribute(CleanCodeAttribute var1);

        public abstract NewRule addDescriptionSection(RuleDescriptionSection var1);

        public abstract NewRule setHtmlDescription(@Nullable String var1);

        public abstract NewRule setHtmlDescription(@Nullable URL var1);

        @Deprecated(since="9.6", forRemoval=true)
        public abstract NewRule setMarkdownDescription(@Nullable String var1);

        @Deprecated(since="9.6", forRemoval=true)
        public abstract NewRule setMarkdownDescription(@Nullable URL var1);

        public abstract NewRule setStatus(RuleStatus var1);

        public abstract DebtRemediationFunctions debtRemediationFunctions();

        public abstract NewRule setDebtRemediationFunction(@Nullable DebtRemediationFunction var1);

        public abstract NewRule setGapDescription(@Nullable String var1);

        public abstract NewParam createParam(String var1);

        @CheckForNull
        public abstract NewParam param(String var1);

        public abstract Collection<NewParam> params();

        public abstract NewRule addTags(String ... var1);

        public abstract NewRule setTags(String ... var1);

        @Deprecated
        public abstract NewRule addOwaspTop10(OwaspTop10 ... var1);

        public abstract NewRule addOwaspTop10(OwaspTop10Version var1, OwaspTop10 ... var2);

        public abstract NewRule addOwaspMobileTop10(OwaspMobileTop10Version var1, OwaspMobileTop10 ... var2);

        public abstract NewRule addPciDss(PciDssVersion var1, String ... var2);

        public abstract NewRule addOwaspAsvs(OwaspAsvsVersion var1, String ... var2);

        public abstract NewRule addCwe(int ... var1);

        public abstract NewRule addStig(StigVersion var1, String ... var2);

        public abstract NewRule setInternalKey(@Nullable String var1);

        public abstract NewRule addDeprecatedRuleKey(String var1, String var2);

        public abstract NewRule addEducationPrincipleKeys(String ... var1);
    }

    public static interface DebtRemediationFunctions {
        public DebtRemediationFunction linear(String var1);

        public DebtRemediationFunction linearWithOffset(String var1, String var2);

        public DebtRemediationFunction constantPerIssue(String var1);

        public DebtRemediationFunction create(DebtRemediationFunction.Type var1, @Nullable String var2, @Nullable String var3);
    }

    public static interface Repository
    extends ExtendedRepository {
        public String name();

        public boolean isExternal();
    }

    public static interface ExtendedRepository {
        public String key();

        public String language();

        @CheckForNull
        public Rule rule(String var1);

        public List<Rule> rules();
    }

    public static enum StigVersion {
        ASD_V5R3("ASD_V5R3", "stig-ASD_V5R3");

        private final String label;
        private final String prefix;

        private StigVersion(String label, String prefix) {
            this.label = label;
            this.prefix = prefix;
        }

        public String label() {
            return this.label;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static enum OwaspAsvsVersion {
        V4_0("4.0", "owaspAsvs-4.0");

        private final String label;
        private final String prefix;

        private OwaspAsvsVersion(String label, String prefix) {
            this.label = label;
            this.prefix = prefix;
        }

        public String label() {
            return this.label;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static enum PciDssVersion {
        V3_2("3.2", "pciDss-3.2"),
        V4_0("4.0", "pciDss-4.0");

        private final String label;
        private final String prefix;

        private PciDssVersion(String label, String prefix) {
            this.label = label;
            this.prefix = prefix;
        }

        public String label() {
            return this.label;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static enum OwaspMobileTop10 {
        M1,
        M2,
        M3,
        M4,
        M5,
        M6,
        M7,
        M8,
        M9,
        M10;

    }

    public static enum OwaspTop10 {
        A1,
        A2,
        A3,
        A4,
        A5,
        A6,
        A7,
        A8,
        A9,
        A10;

    }

    public static enum OwaspMobileTop10Version {
        Y2024("2024", "owaspMobileTop10-2024");

        private final String label;
        private final String prefix;

        private OwaspMobileTop10Version(String label, String prefix) {
            this.label = label;
            this.prefix = prefix;
        }

        public String label() {
            return this.label;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static enum OwaspTop10Version {
        Y2017("2017", "owaspTop10"),
        Y2021("2021", "owaspTop10-2021");

        private final String label;
        private final String prefix;

        private OwaspTop10Version(String label, String prefix) {
            this.label = label;
            this.prefix = prefix;
        }

        public String label() {
            return this.label;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    @Deprecated(since="9.15")
    public static enum CweVersion {
        Y2020("2020"),
        Y2021("2021");

        private final String label;

        private CweVersion(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }
    }

    public static interface NewRepository
    extends NewExtendedRepository {
        public NewRepository setName(String var1);

        public boolean isExternal();
    }

    public static interface NewExtendedRepository {
        public NewRule createRule(String var1);

        @CheckForNull
        public NewRule rule(String var1);

        public Collection<NewRule> rules();

        public String key();

        public void done();
    }

    public static abstract class AbstractContext {
        public abstract NewRepository createRepository(String var1, String var2);

        public abstract NewRepository createExternalRepository(String var1, String var2);

        @CheckForNull
        public abstract Repository repository(String var1);

        public abstract List<Repository> repositories();

        public abstract void setCurrentPluginKey(@Nullable String var1);
    }

    public static class Context
    extends AbstractContext {
        private final Map<String, Repository> repositoriesByKey = new HashMap<String, Repository>();
        private String currentPluginKey = null;

        @Override
        public NewRepository createRepository(String key, String language) {
            return new DefaultNewRepository(this, key, language, false);
        }

        @Override
        public NewRepository createExternalRepository(String engineId, String language) {
            return new DefaultNewRepository(this, "external_" + engineId, language, true);
        }

        @Override
        @CheckForNull
        public Repository repository(String key) {
            return this.repositoriesByKey.get(key);
        }

        @Override
        public List<Repository> repositories() {
            return Collections.unmodifiableList(new ArrayList<Repository>(this.repositoriesByKey.values()));
        }

        public void registerRepository(DefaultNewRepository newRepository) {
            Repository existing = this.repositoriesByKey.get(newRepository.key());
            if (existing != null) {
                String existingLanguage = existing.language();
                Preconditions.checkState(existingLanguage.equals(newRepository.language()), "The rule repository '%s' must not be defined for two different languages: %s and %s", newRepository.key(), existingLanguage, newRepository.language());
            }
            this.repositoriesByKey.put(newRepository.key(), new DefaultRepository(newRepository, existing));
        }

        public String currentPluginKey() {
            return this.currentPluginKey;
        }

        @Override
        public void setCurrentPluginKey(@Nullable String pluginKey) {
            this.currentPluginKey = pluginKey;
        }
    }
}

