/*
 * Sonar Plugin API
 * Copyright (C) 2009-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.api.server.ws.impl;

import java.io.InputStream;
import org.sonar.api.server.ws.Request;

public class PartImpl implements Request.Part {

  private final InputStream inputStream;
  private final String fileName;

  public PartImpl(InputStream inputStream, String fileName) {
    this.inputStream = inputStream;
    this.fileName = fileName;
  }

  @Override
  public InputStream getInputStream() {
    return inputStream;
  }

  @Override
  public String getFileName() {
    return fileName;
  }
}
