/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.testfixtures.measure;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.IssueStatus;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Preconditions;

@Immutable
public class TestIssue
implements org.sonar.api.ce.measure.Issue {
    private final String key;
    private final String status;
    private final String resolution;
    private final String severity;
    private final RuleKey ruleKey;
    private final Duration effort;
    private final RuleType type;
    private final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts;

    private TestIssue(Builder builder) {
        this.key = builder.key;
        this.status = builder.status;
        this.resolution = builder.resolution;
        this.severity = builder.severity;
        this.ruleKey = builder.ruleKey;
        this.effort = builder.effort;
        this.type = builder.type;
        this.impacts = Collections.unmodifiableMap(builder.impacts);
    }

    public String key() {
        return this.key;
    }

    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    @Deprecated(since="10.4")
    public String status() {
        return this.status;
    }

    @CheckForNull
    @Deprecated(since="10.4")
    public String resolution() {
        return this.resolution;
    }

    public IssueStatus issueStatus() {
        return IssueStatus.of((String)this.status, (String)this.resolution);
    }

    public String severity() {
        return this.severity;
    }

    public Duration effort() {
        return this.effort;
    }

    public RuleType type() {
        return this.type;
    }

    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts() {
        return this.impacts;
    }

    public static class Builder {
        private String key;
        private String status;
        private String resolution;
        private String severity;
        private final Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
        private RuleKey ruleKey;
        private Duration effort;
        private RuleType type;

        public Builder setKey(String key) {
            this.key = Builder.validateKey(key);
            return this;
        }

        public Builder setResolution(@Nullable String resolution) {
            this.resolution = Builder.validateResolution(resolution);
            return this;
        }

        @Deprecated(since="10.1")
        public Builder setSeverity(String severity) {
            this.severity = Builder.validateSeverity(severity);
            return this;
        }

        public Builder addImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
            Builder.validateImpacts(this.impacts, softwareQuality);
            this.impacts.put(softwareQuality, severity);
            return this;
        }

        public Builder setStatus(String status) {
            this.status = Builder.validateStatus(status);
            return this;
        }

        public Builder setRuleKey(RuleKey ruleKey) {
            this.ruleKey = Builder.validateRuleKey(ruleKey);
            return this;
        }

        public Builder setEffort(@Nullable Duration effort) {
            this.effort = effort;
            return this;
        }

        @Deprecated(since="10.1")
        public Builder setType(RuleType type) {
            this.type = Builder.validateType(type);
            return this;
        }

        private static String validateKey(String key) {
            Objects.requireNonNull(key, "key cannot be null");
            return key;
        }

        private static RuleKey validateRuleKey(RuleKey ruleKey) {
            Objects.requireNonNull(ruleKey, "ruleKey cannot be null");
            return ruleKey;
        }

        private static String validateResolution(@Nullable String resolution) {
            Preconditions.checkArgument((resolution == null || Issue.RESOLUTIONS.contains(resolution) ? 1 : 0) != 0, (String)String.format("resolution '%s' is invalid", resolution));
            return resolution;
        }

        private static String validateSeverity(String severity) {
            Objects.requireNonNull(severity, "severity cannot be null");
            Preconditions.checkArgument((boolean)Severity.ALL.contains(severity), (String)String.format("severity '%s' is invalid", severity));
            return severity;
        }

        private static String validateStatus(String status) {
            Objects.requireNonNull(status, "status cannot be null");
            Preconditions.checkArgument((boolean)Issue.STATUSES.contains(status), (String)String.format("status '%s' is invalid", status));
            return status;
        }

        private static RuleType validateType(RuleType type) {
            Objects.requireNonNull(type, "type cannot be null");
            return type;
        }

        private static void validateImpacts(Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts, SoftwareQuality softwareQuality) {
            Preconditions.checkArgument((!impacts.containsKey(softwareQuality) ? 1 : 0) != 0, (String)"Software quality %s is already defined in impacts", (Object[])new Object[]{softwareQuality});
        }

        public org.sonar.api.ce.measure.Issue build() {
            Builder.validateKey(this.key);
            Builder.validateResolution(this.resolution);
            Builder.validateSeverity(this.severity);
            Builder.validateStatus(this.status);
            Builder.validateRuleKey(this.ruleKey);
            Builder.validateType(this.type);
            return new TestIssue(this);
        }
    }
}

