/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Inventory;
import org.solovyev.android.checkout.ProductTypes;
import org.solovyev.android.checkout.Purchase;

public final class RobotmediaDatabase {
    static final String NAME = "billing.db";
    @Nonnull
    private final Context mContext;

    public RobotmediaDatabase(@Nonnull Context context) {
        this.mContext = context;
    }

    public static boolean exists(@Nonnull Context context) {
        File file = RobotmediaDatabase.getDatabaseFile(context);
        return file != null && file.exists();
    }

    @Nullable
    private static File getDatabaseFile(@Nonnull Context context) {
        return context.getDatabasePath(NAME);
    }

    @Nullable
    static String getDatabasePath(@Nonnull Context context) {
        File file = RobotmediaDatabase.getDatabaseFile(context);
        return file != null ? file.getPath() : null;
    }

    @Nonnull
    static Inventory.Products toInventoryProducts(@Nonnull Collection<String> products) {
        Inventory.Products result = new Inventory.Products();
        for (String productId : products) {
            result.add(new Inventory.Product(productId, true));
        }
        return result;
    }

    @Nonnull
    static String makeInClause(int count) {
        Check.isTrue(count > 0, "Should be positive");
        StringBuilder sb = new StringBuilder(count * 2 + 1);
        sb.append("(");
        sb.append("?");
        for (int i = 1; i < count; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Inventory.Products load(@Nonnull Inventory.Request request) {
        try (SQLiteDatabase db = null;){
            String databasePath = RobotmediaDatabase.getDatabasePath(this.mContext);
            db = SQLiteDatabase.openDatabase((String)databasePath, null, (int)1);
            Inventory.Products products = this.loadProducts(request, db);
            return products;
        }
        return RobotmediaDatabase.toInventoryProducts(ProductTypes.ALL);
    }

    @Nonnull
    private Inventory.Products loadProducts(@Nonnull Inventory.Request request, @Nonnull SQLiteDatabase db) {
        Inventory.Products result = new Inventory.Products();
        for (String productId : ProductTypes.ALL) {
            Inventory.Product product = new Inventory.Product(productId, true);
            List<String> skus = request.getSkus(productId);
            if (!skus.isEmpty()) {
                product.setPurchases(this.loadPurchases(skus, db));
            } else {
                Billing.warning("There are no SKUs for \"" + product.id + "\" product. No purchase information will be loaded");
            }
            result.add(product);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<Purchase> loadPurchases(@Nonnull List<String> skus, @Nonnull SQLiteDatabase db) {
        Check.isNotEmpty(skus);
        ArrayList<Purchase> purchases = new ArrayList<Purchase>(skus.size());
        String[] columns = new String[]{"_id", "state", "productId", "purchaseTime", "developerPayload"};
        String packageName = this.mContext.getPackageName();
        try (Cursor c = null;){
            c = db.query("purchases", columns, "productId in " + RobotmediaDatabase.makeInClause(skus.size()), skus.toArray(new String[skus.size()]), null, null, null);
            if (c.moveToFirst()) {
                do {
                    String orderId = c.getString(0);
                    int state = c.getInt(1);
                    String sku = c.getString(2);
                    long time = c.getLong(3);
                    String payload = c.getString(4);
                    Purchase p = new Purchase(sku, orderId, packageName, time, state, payload, "", false, "", "");
                    purchases.add(p);
                } while (c.moveToNext());
            }
        }
        return purchases;
    }
}

