/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.text.TextUtils;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.json.JSONException;
import org.json.JSONObject;

@Immutable
public final class Purchase {
    @Nonnull
    public final String sku;
    @Nonnull
    public final String orderId;
    @Nonnull
    public final String packageName;
    public final long time;
    @Nonnull
    public final State state;
    @Nonnull
    public final String payload;
    @Nonnull
    public final String token;
    public final boolean autoRenewing;
    @Nonnull
    public final String data;
    @Nonnull
    public final String signature;

    Purchase(@Nonnull String sku, @Nonnull String orderId, @Nonnull String packageName, long time, int state, @Nonnull String payload, @Nonnull String token, boolean autoRenewing, @Nonnull String data, @Nonnull String signature) {
        this.sku = sku;
        this.orderId = orderId;
        this.packageName = packageName;
        this.time = time;
        this.state = State.valueOf(state);
        this.payload = payload;
        this.token = token;
        this.autoRenewing = autoRenewing;
        this.signature = signature;
        this.data = data;
    }

    Purchase(@Nonnull String data, @Nonnull String signature) throws JSONException {
        JSONObject json = new JSONObject(data);
        this.sku = json.getString("productId");
        this.orderId = json.optString("orderId");
        this.packageName = json.optString("packageName");
        this.time = json.getLong("purchaseTime");
        this.state = State.valueOf(json.optInt("purchaseState", 0));
        this.payload = json.optString("developerPayload");
        this.token = json.optString("token", json.optString("purchaseToken"));
        this.autoRenewing = json.optBoolean("autoRenewing");
        this.data = data;
        this.signature = signature;
    }

    @Nonnull
    static Purchase fromJson(@Nonnull String data, @Nonnull String signature) throws JSONException {
        return new Purchase(data, signature);
    }

    private static void tryPut(@Nonnull JSONObject json, @Nonnull String key, @Nonnull String name) throws JSONException {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            json.put(key, (Object)name);
        }
    }

    @Nonnull
    public String toJson() {
        return this.toJson(false);
    }

    @Nonnull
    public String toJson(boolean withSignature) {
        return this.toJsonObject(withSignature).toString();
    }

    @Nonnull
    JSONObject toJsonObject(boolean withSignature) {
        JSONObject json = new JSONObject();
        try {
            json.put("productId", (Object)this.sku);
            Purchase.tryPut(json, "orderId", this.orderId);
            Purchase.tryPut(json, "packageName", this.packageName);
            json.put("purchaseTime", this.time);
            json.put("purchaseState", this.state.id);
            Purchase.tryPut(json, "developerPayload", this.payload);
            Purchase.tryPut(json, "token", this.token);
            if (this.autoRenewing) {
                json.put("autoRenewing", true);
            }
            if (withSignature) {
                Purchase.tryPut(json, "signature", this.signature);
            }
        }
        catch (JSONException e) {
            throw new AssertionError((Object)e);
        }
        return json;
    }

    public String toString() {
        return "Purchase{state=" + (Object)((Object)this.state) + ", time=" + this.time + ", sku='" + this.sku + '\'' + '}';
    }

    public static enum State {
        PURCHASED(0),
        CANCELLED(1),
        REFUNDED(2),
        EXPIRED(3);

        public final int id;

        private State(int id) {
            this.id = id;
        }

        @Nonnull
        static State valueOf(int id) {
            switch (id) {
                case 0: {
                    return PURCHASED;
                }
                case 1: {
                    return CANCELLED;
                }
                case 2: {
                    return REFUNDED;
                }
                case 3: {
                    return EXPIRED;
                }
            }
            throw new IllegalArgumentException("Id=" + id + " is not supported");
        }
    }
}

