/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestRunnable;

final class PendingRequests
implements Runnable {
    @Nonnull
    @GuardedBy(value="mList")
    private final List<RequestRunnable> mList = new ArrayList<RequestRunnable>();

    PendingRequests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(@Nonnull RequestRunnable runnable) {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            Billing.debug("Adding pending request: " + runnable);
            this.mList.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll() {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            Billing.debug("Cancelling all pending requests");
            Iterator<RequestRunnable> iterator = this.mList.iterator();
            while (iterator.hasNext()) {
                RequestRunnable request = iterator.next();
                request.cancel();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll(@Nullable Object tag) {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            Billing.debug("Cancelling all pending requests with tag=" + tag);
            Iterator<RequestRunnable> iterator = this.mList.iterator();
            while (iterator.hasNext()) {
                RequestRunnable request = iterator.next();
                Object requestTag = request.getTag();
                if (requestTag == tag) {
                    request.cancel();
                    iterator.remove();
                    continue;
                }
                if (requestTag != null && tag == null || requestTag == null || !requestTag.equals(tag)) continue;
                request.cancel();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(int requestId) {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            Billing.debug("Cancelling pending request with id=" + requestId);
            Iterator<RequestRunnable> iterator = this.mList.iterator();
            while (iterator.hasNext()) {
                RequestRunnable request = iterator.next();
                if (request.getId() != requestId) continue;
                request.cancel();
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RequestRunnable pop() {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            RequestRunnable runnable;
            RequestRunnable requestRunnable = runnable = !this.mList.isEmpty() ? this.mList.remove(0) : null;
            if (runnable != null) {
                Billing.debug("Removing pending request: " + runnable);
            }
            return runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RequestRunnable peek() {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            return !this.mList.isEmpty() ? this.mList.get(0) : null;
        }
    }

    @Override
    public void run() {
        RequestRunnable runnable = this.peek();
        while (runnable != null) {
            Billing.debug("Running pending request: " + runnable);
            if (!runnable.run()) break;
            this.remove(runnable);
            runnable = this.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(@Nonnull RequestRunnable runnable) {
        List<RequestRunnable> list = this.mList;
        synchronized (list) {
            Iterator<RequestRunnable> iterator = this.mList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != runnable) continue;
                Billing.debug("Removing pending request: " + runnable);
                iterator.remove();
                break;
            }
        }
    }

    void onConnectionFailed() {
        Check.isMainThread();
        RequestRunnable requestRunnable = this.pop();
        while (requestRunnable != null) {
            Request request = requestRunnable.getRequest();
            if (request != null) {
                request.onError(10000);
                requestRunnable.cancel();
            }
            requestRunnable = this.pop();
        }
    }
}

