/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.InAppBillingService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestType;

final class BillingSupportedRequest
extends Request<Object> {
    @Nonnull
    private final String mProduct;
    @Nullable
    private final Bundle mExtraParams;

    BillingSupportedRequest(@Nonnull String product) {
        this(product, 3, null);
    }

    BillingSupportedRequest(@Nonnull String product, int apiVersion, @Nullable Bundle extraParams) {
        super(RequestType.BILLING_SUPPORTED, apiVersion);
        Check.isTrue(extraParams == null || apiVersion >= 7, "#isBillingSupportedExtraParams only works in Billing API v7 or higher");
        this.mProduct = product;
        this.mExtraParams = extraParams;
    }

    @Override
    public void start(@Nonnull InAppBillingService service, @Nonnull String packageName) throws RemoteException {
        int response;
        int n = response = this.mExtraParams != null ? service.isBillingSupportedExtraParams(this.mApiVersion, packageName, this.mProduct, this.mExtraParams) : service.isBillingSupported(this.mApiVersion, packageName, this.mProduct);
        if (!this.handleError(response)) {
            this.onSuccess(new Object());
        }
    }

    @Override
    @Nullable
    protected String getCacheKey() {
        if (this.mExtraParams != null) {
            return null;
        }
        if (this.mApiVersion == 3) {
            return this.mProduct;
        }
        return this.mProduct + "_" + this.mApiVersion;
    }
}

