/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Checkout;
import org.solovyev.android.checkout.Inventory;
import org.solovyev.android.checkout.RequestListener;

public abstract class BaseInventory
implements Inventory {
    @Nonnull
    protected final Object mLock;
    @Nonnull
    protected final Checkout mCheckout;
    @Nonnull
    @GuardedBy(value="mLock")
    private final List<Task> mTasks = new ArrayList<Task>();
    private final AtomicInteger mTaskIdGenerator = new AtomicInteger();

    protected BaseInventory(@Nonnull Checkout checkout) {
        this.mCheckout = checkout;
        this.mLock = checkout.mLock;
    }

    @Override
    public void cancel() {
        for (Task task : this.getTasksCopy()) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(int id) {
        Object object = this.mLock;
        synchronized (object) {
            for (Task task : this.mTasks) {
                if (task.mId != id) continue;
                task.cancel();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<Task> getTasksCopy() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<Task>(this.mTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoading() {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            return !this.mTasks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int load(@Nonnull Inventory.Request request, @Nonnull Inventory.Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            Task task = new Task(request, callback);
            this.mTasks.add(task);
            task.run();
            return task.mId;
        }
    }

    protected final <R> RequestListener<R> synchronizedListener(@Nonnull RequestListener<R> l) {
        return new SynchronizedRequestListener<R>(l);
    }

    @Nonnull
    protected abstract Runnable createWorker(@Nonnull Task var1);

    private final class SynchronizedRequestListener<R>
    implements RequestListener<R> {
        private final RequestListener<R> mListener;

        public SynchronizedRequestListener(RequestListener<R> listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(@Nonnull R result) {
            Object object = BaseInventory.this.mLock;
            synchronized (object) {
                this.mListener.onSuccess(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int response, @Nonnull Exception e) {
            Object object = BaseInventory.this.mLock;
            synchronized (object) {
                this.mListener.onError(response, e);
            }
        }
    }

    protected final class Task {
        private final int mId;
        @Nonnull
        private final Inventory.Request mRequest;
        @Nullable
        @GuardedBy(value="mLock")
        private Inventory.Callback mCallback;
        @GuardedBy(value="mLock")
        private final Inventory.Products mProducts;

        public Task(@Nonnull Inventory.Request request, Inventory.Callback callback) {
            this.mId = BaseInventory.this.mTaskIdGenerator.getAndIncrement();
            this.mProducts = new Inventory.Products();
            this.mRequest = request.copy();
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            Object object = BaseInventory.this.mLock;
            synchronized (object) {
                return this.mCallback == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = BaseInventory.this.mLock;
            synchronized (object) {
                this.mCallback = null;
                BaseInventory.this.mTasks.remove(this);
            }
        }

        public void run() {
            BaseInventory.this.createWorker(this).run();
        }

        @Nonnull
        public Inventory.Request getRequest() {
            return this.mRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDone(@Nonnull Inventory.Products products) {
            Object object = BaseInventory.this.mLock;
            synchronized (object) {
                this.mProducts.merge(products);
                this.onDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onMaybeDone(@Nonnull Inventory.Products products) {
            Object object = BaseInventory.this.mLock;
            synchronized (object) {
                this.mProducts.merge(products);
                if (!this.existsUnsupported()) {
                    this.onDone();
                    return true;
                }
                return false;
            }
        }

        private void onDone() {
            Check.isTrue(Thread.holdsLock(BaseInventory.this.mLock), "Must be synchronized");
            if (this.mCallback == null) {
                return;
            }
            BaseInventory.this.mTasks.remove(this);
            this.mCallback.onLoaded(this.mProducts);
            this.mCallback = null;
        }

        private boolean existsUnsupported() {
            Check.isTrue(Thread.holdsLock(BaseInventory.this.mLock), "Must be synchronized");
            for (Inventory.Product product : this.mProducts) {
                if (product.supported) continue;
                return true;
            }
            return false;
        }
    }
}

