/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.util;

import java.io.IOException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.context.notification.EndpointMessageNotification;
import org.springframework.context.ApplicationContext;

public class MuleUtil {
    private MuleUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static Object getSpringBean(MuleContext muleContext, String beanName) {
        ApplicationContext ac = (ApplicationContext)muleContext.getRegistry().lookupObject("springApplicationContext");
        return ac.getBean(beanName);
    }

    public static String getServiceName(MuleEventContext event) {
        FlowConstruct service = event == null ? null : event.getFlowConstruct();
        String name = service == null ? "" : service.getName();
        return name;
    }

    public static MuleMessage createMuleMessage(Object message, MuleContext muleContext) {
        return new DefaultMuleMessage(message, muleContext);
    }

    public static String getEndpointName(EndpointMessageNotification notification) {
        return notification.getEndpoint();
    }

    public static ImmutableEndpoint getImmutableEndpoint(MuleContext muleContext, String endpointName) throws IOException {
        ImmutableEndpoint endpoint = null;
        Object o = muleContext.getRegistry().lookupObject(endpointName);
        if (o instanceof ImmutableEndpoint) {
            endpoint = (ImmutableEndpoint)o;
        } else if (o instanceof EndpointBuilder) {
            EndpointBuilder eb = (EndpointBuilder)o;
            try {
                endpoint = eb.buildInboundEndpoint();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        return endpoint;
    }

    public static String getFlowVariable(MuleMessage message, String name) {
        return (String)message.getInvocationProperty(name);
    }
}

