/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestConsumer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestConsumer.class);
    private static final String CLASSPATH_PROTOCOL = "classpath:";
    private static final int CLASSPATH_PROTOCOL_LEN = "classpath:".length();

    public static String getAddress(String uri, int httpPort, String ctxPath, String servletUri) {
        String url = "http://localhost:" + httpPort + ctxPath + servletUri + "/" + uri;
        log.info("URL: {}", (Object)url);
        return url;
    }

    protected URL createEndpointUrlFromServiceAddress(String serviceAddress) {
        try {
            if (serviceAddress.startsWith(CLASSPATH_PROTOCOL)) {
                serviceAddress = serviceAddress.substring(CLASSPATH_PROTOCOL_LEN);
                return this.getClass().getResource(serviceAddress);
            }
            return new URL(serviceAddress + "?wsdl");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL Exception: " + e.getMessage());
        }
    }
}

