/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.soap;

import java.text.MessageFormat;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSoapFaultIfExceptionTransformer
extends AbstractMessageTransformer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    static String SOAP_FAULT_V11 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soapenv:Header/>  <soapenv:Body>    <soap:Fault xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n      <faultcode>soap:Server</faultcode>\n      <faultstring>{0}</faultstring>\n      <faultactor>{1}</faultactor>\n      <detail>\n        {2}\n      </detail>\n    </soap:Fault>  </soapenv:Body></soapenv:Envelope>";

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        this.logger.debug("transform() called");
        ExceptionPayload ep = message.getExceptionPayload();
        if (ep == null) {
            this.logger.debug("No error, return origin message");
            return message;
        }
        this.logger.debug("ExceptionPayload detected as well, let's create a SOAP-FAULT!");
        String soapFault = this.createSoapFaultFromExceptionPayload(ep);
        this.logger.debug("Created soapFault: {}", (Object)soapFault);
        this.logger.debug("Set ExceptionPayload to null and outbound http.status=500");
        message.setExceptionPayload(null);
        message.setProperty("http.status", (Object)500, PropertyScope.OUTBOUND);
        message.setPayload((Object)soapFault);
        return message;
    }

    protected String createSoapFaultFromExceptionPayload(ExceptionPayload exceptionPayload) {
        this.logger.debug("Exception: " + exceptionPayload.getException() + ", " + exceptionPayload.getException().getClass().getName());
        this.logger.debug("RootException: " + exceptionPayload.getRootException() + ", " + exceptionPayload.getRootException().getClass().getName());
        Throwable e = exceptionPayload.getRootException() != null ? exceptionPayload.getRootException() : exceptionPayload.getException();
        String errMsg = e.getMessage();
        String endpoint = null;
        ImmutableEndpoint ie = this.getEndpoint();
        if (ie != null) {
            endpoint = this.getEndpoint().getEndpointURI().getAddress();
        } else if (exceptionPayload.getException() instanceof DispatchException) {
            DispatchException de = (DispatchException)exceptionPayload.getException();
            endpoint = (String)de.getEvent().getMessage().getProperty("MULE_ENDPOINT", PropertyScope.OUTBOUND);
        } else if (exceptionPayload.getException() instanceof TransformerMessagingException) {
            TransformerMessagingException tme = (TransformerMessagingException)exceptionPayload.getException();
            endpoint = (String)tme.getEvent().getMessage().getProperty("http.context.uri", PropertyScope.INBOUND);
        }
        String detail = e.getMessage();
        return this.createSoapFault(errMsg, endpoint, detail);
    }

    protected String createSoapFault(String errMsg, String endpoint, String details) {
        return MessageFormat.format(SOAP_FAULT_V11, errMsg, endpoint, details);
    }
}

